const { loginfo } = require("../utils/utils");
const { CODE_TYPES } = require("../utils/constants");
const ResultsModel = require("../utils/results.model");
let resultsModel = new ResultsModel();
const ActivityTopService = require("../service/activitytop.service");

//通过状态获取top商品列表
const findItemListByStatusAction = async function (context) {
  loginfo(context, "findItemListByStatus");
  let ActivityTop = new ActivityTopService(context);
  try {
    let result = await ActivityTop.getItemListByStatus();
    return result;
  } catch (e) {
    console.log(e, "获取top商品列表失败");
    return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, "获取top商品列表失败");
  }
};

//通过itemIds获取商品列表
const findItemListByIdsAction = async (context) => {
  loginfo(context, "findItemListByIdsAction");
  let ActivityTop = new ActivityTopService(context);
  try {
    let result = ActivityTop.getItemListByIds();
    return result;
  } catch (e) {
    console.log(e, "获取商品列表失败");
    return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, "获取商品列表失败");
  }
};

//通过ename获取权益信息
const getBenefitByEname = async (context) => {
  loginfo(context, "getBenefitByEname");
  let ActivityTop = new ActivityTopService(context);
  try {
    let result = await ActivityTop.getPrizeByEname();
    return result;
  } catch (e) {
    console.log(e, "获取ename权益信息失败");
    return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, "获取ename权益信息失败");
  }
};

//测试getTemplateInstantiate
const getTemplateInstantiate = async (context) => {
  loginfo(context, "getTemplateInstantiate");
  let ActivityTop = new ActivityTopService(context);
  try {
    let result = await ActivityTop.getTemplateInstantiate();
    return result;
  } catch (e) {
    console.log(e, "获取getTemplateInstantiate失败");
    return resultsModel.error(
      CODE_TYPES.SYSTEM_ERROR,
      "获取getTemplateInstantiate失败"
    );
  }
};

module.exports = {
  findItemListByIdsAction,
  findItemListByStatusAction,
  getBenefitByEname,
  getTemplateInstantiate,
};
