import { TASK_RATE_TYPE } from '../const'
import flatten from 'lodash/flatten'
import { rankTableValidator } from "../../../utils/validate";

// 使用 async-validator 校验
// 文档地址: https://github.com/yiminghe/async-validator
export const descriptor = {
  title: {
    required: true,
    validator: (rule, value) => {
      value = value.trim();
      return !!value && value.length <= 12
    },
    message: "请输入正确的活动名称"
  },

  subtitle: {
    required: true,
    validator: (rule, value) => {
      value = value.trim();
      return !!value && value.length <= 16
    },
    message: "请输入正确的活动副标题"
  },
  prizeInfoList: {
    required: true,
    validator: rankTableValidator
  },
  timeRange: {required: true
  },
  logoImg: {
    required: true,
    message: '请配置图片'
  },
  commandTitle: {
    required: true,
    validator: (rule, value) => {
      value = value.trim();
      return !!value;
    },
    message: '请输入淘口令名称'
  },
  beenInvitedText: {
    required: true,
    validator: (rule, value) => {
      value = value.trim();
      return !!value;
    },
    message: '请输入被邀请者文案'
  },
  commandImg: {
    required: true,
    message: '请输入淘口令图片'
  },
  rule: {
    required: true,
    validator: (rule, value) => {
      value = value.trim();
      return !!value;
    },
    message: '请输入活动规则'
  },
  taskMap: {
    type: 'object',
    required: true,
    fields: {
      beMembership: {
        validator: (rule, val, cb, source) => {
          if(!source.beMembership.checked) return true;
          return !!val.value
        },
        message: '请输入成为会员任务的奖励'
      },
      inviteFriends: {
        validator: (rule, val, cb, source) => {
          if(!source.inviteFriends.checked) return true;
          return !!(val.title && val.value)
        },
        message: '请输入邀请任务'
      },
      jumpLink: {
        validator: (rule, val, cb, source) => {
          if(!source.jumpLink.checked) return true;
          return !!(val.title && val.value && val.link);
        },
        message: '请输入浏览指定页面任务'
      },
      browseGoods: {
        validator: (rule, val) => {
          return !!(val.itemIds);
        },
        message: '请输入寻宝屋商品任务'
      }
    }
  }
};



export const formatValidator = (descriptor, validators) => {
  validators = validators || {}
  Object.keys(descriptor).forEach(key => {
    if(descriptor[key].fields) {
      Object.keys(descriptor[key].fields).forEach(fieldKey => {
        validators[`${key}.${fieldKey}`] = {
          status: 'success',
          message: ''
        }
      })
    } else {
      validators[key] = {
        status: 'success',
        message: ''
      }
    }
    
  });
  return validators
}