Component({
  mixins: [],
  data: {
    dialogVisible: false,
    isEdit: false,
    prizeDialogData: {}
  },
  props: {
    limit: 20,
    imageLimit: [ 200, 200],
    fixedRank: [],
    maxRankLimit: '',
    list: [],
    onChange: () => {},
    dataName: ''
  },
  didMount() {},
  didUpdate() {},
  didUnmount() {},
  methods: {
    // 格式化排名信息
    formatRank(rank) {
      return rank
    },
     // 删除奖品
    handleDeleteClick(e) {
      const { index } = e.target.dataset.x;
      const { onChange, list } = this.props;
      onChange && onChange(list.filter(((i, k) => k !== index)))
    },
    addPrize() {
      const { limit, list } = this.props;

      if (list.length >= limit)  {
        my.showToast({ type: 'fail', content: `最多创建${limit}个奖励配置` });
        return;
      }

      this.setData({ 
        dialogVisible: true, 
        isEdit: false,
        prizeDialogData: {}
      })

    },
    onEditPrize(e) {
      const { name, x } = e.target.dataset;
      this.setData({
        prizeDialogData: x,
        isEdit: true,
        dialogVisible: true
      })
    },
    onCloseDialog() {
      this.setData({ dialogVisible: false })
    },
    onPrizeUpdate(data, index) {
      const { onChange, list, dataName } = this.props;

      const updatedData = list.map((v, i) => {
        if(index === i) return {...v, ...data}
        return v;
      })

      onChange && onChange(updatedData, dataName)
    },
    onPrizeAdd(data) {
      const { list, onChange, dataName } = this.props;

      let newList = [...list, data].sort((a, b) => {
        let prevRank = a.rank.split('-')[0]
        let nextRank = b.rank.split('-')[0]
        return prevRank - nextRank;
      })

      onChange && onChange(newList, dataName)
    }
  },
});
