import dayjs from "dayjs";

import {
  getActivityList,
  delActivity,
  findWinnerInfoList,
  uploadDataCreateFile,
  createCopyActivity,
} from "/api";
import { appId } from "/config";
import { setClipboard } from "/utils";


Component({
  data: {
    isLoadingList: false,
    exportDialogVisible: false,
    exportUrl: '',
    dataSource: [],
    confirmDialog: {
      visible: false,
      content: "删除活动后该活动用户参与信息将全部删除，确认删除吗？",
    },
    pageInfo: {
      pageNo: 1,
      pgaeSize: 10,
      total: 0
    },
    deleteId: "",
    winnerListDialogVisible: false,
    winnerList: [],
    selectedItem: {}
  },
  props: {
    buttons: ['edit', 'export', 'delete', 'copyLink']
  },
  didMount() {
    this.getList();
  },
  methods: {
     /**
     *获取活动列表
     *
     * @param {number} [currentPage=1] 页数
     * @param {number} [size=10] 页码尺寸
     * @returns {void}
     */
    async getList(currentPage = 1, size = 10) {
      this.setData({ isLoadingList: true });
      try {
        const { success, data, message } = await getActivityList({
          pageNo: currentPage,
          pageSize: size,
        });
        this.setData({ isLoadingList: false });

        if (!success) {
          my.showToast({
            type: "fail",
            content: message,
          });
          return;
        }

        const { list, pageNo, pageSize, total } = data;

        const timeNow = new Date().getTime();
        let formatList = list.map((i) => {
          return {
            ...i,
            isEnd: +i.endTime < Date.now(),
            isStart: +i.startTime < Date.now(),
            startTime: dayjs(+i.startTime).format("YYYY-MM-DD HH:mm:ss"),
            endTime: dayjs(+i.endTime).format("YYYY-MM-DD HH:mm:ss"),
          };
        });

        this.setData({
          dataSource: formatList,
          pageInfo: {
            pageNo,
            pageSize,
            total,
          },
        });
      } catch (error) {
        this.setData({
          isLoadingList: false,
        });
      }
    },
    // 获取中奖名单
    async handleOpenWinnerList(evt) {
      const { activityId } = evt.target.dataset.x.record;
      const { data,success } = await findWinnerInfoList({ activityId});

      if (success) {
        this.setData({
          winnerListDialogVisible: true,
          winnerList: data.map(v => {
            return {
              ...v,
              typeName: v.type == 1 ? '优惠券': '实物'
            }
          }),
          selectedItem: evt.target.dataset.x.record
        })
      }
    },
    onCloseWinnerListDialog() {
      this.setData({
        winnerListDialogVisible: false
      })
    },

    // 复制链接
    async onCopyLink(evt) {
      const { activityId } = evt.target.dataset.x.record;
      let text = `https://m.duanqu.com/?_ariver_appid=${appId}?query=activityId%3D${activityId}`
      try {
        await setClipboard({
          text
        });
        my.showToast({
          type: "success",
          content: "复制活动链接成功",
        });
      } catch (error) {
        console.log(error);
      }
    },
    onCloseExportDialog() {
      this.setData({
        exportDialogVisible: false
      })
    },
    //复制新活动
    async onCreateNewActivity(evt) {
      const { activityId } = evt.target.dataset.x.record;
      let res = await createCopyActivity({ activityId });
      if (res.success) {
        this.getList();
      } else {
        my.showToast({
          content: res.message,
          type: "fail",
        });
      }
    },
    toDataPage(evt) {
      const { activityId } = evt.target.dataset.x.record;
      this.$page.$router.push(`/activity/data/${activityId}`);
    },
      // 点击列表删除
    handleTapDelete(evt) {
      const { activityId } = evt.target.dataset.x.record;
      console.log(1)
      this.setData({
        confirmDialog: Object.assign({}, this.data.confirmDialog, {
          visible: true,
        }),
        deleteId: activityId,
      });
    },
    onCloseConfirmDialog() {
      this.setData({
        confirmDialog: Object.assign({}, this.data.confirmDialog, {
          visible: false,
        }),
      });
    },
    onConfirmDelete() {
      const activityId = this.data.deleteId;

      this.setData({
        confirmDialog: Object.assign({}, this.data.confirmDialog, {
          visible: false,
        }),
      });

      activityId && this.deleteActivityFromId(activityId);
    },
    // 删除活动
    async deleteActivityFromId(activityId) {
      try {
        const { success, message } = await delActivity({
          activityId
        });
        if (success) {
          this.getList();
        } else {
          my.showToast({
            type: "fail",
            content: message,
          });
        }
      } catch (error) {
        console.log(error);
      }
    },
    // 导出中奖名单
    async exportWinnerList(evt) {
      const { activityId } = evt.target.dataset.x.record;
      const { type } = evt.target.dataset;
      let isObject = type === "object";
      my.showLoading({ content: "生成文件中..." });
      try {
        const { success, data, message } = await uploadDataCreateFile({
          activityId,
          isObject,
        });
        my.hideLoading();

        if (success) {
          await setClipboard({ text: data.url.replace(/amp;/g, "") });
          this.setData({
            exportDialogVisible: true,
            exportUrl: data.url.replace(/amp;/g, "")
          })
        } else {
          my.showToast({
            type: "fail",
            content: message,
          });
        }
      } catch (error) {
        my.hideLoading();
        console.log(error, "exportList-error");
      }
    },
    // 编辑
    handleClickEdit(evt) {
      let { activityId } = evt.target.dataset.x.record;
      this.$page.$router.push(`/activity/edit/${activityId}`);
    },
    changePagination(evt) {
      const { value } = evt.detail;
      this.getList(value);
    },
  },
});
