import { getUserAddress, commonToast } from './tb';
import { getRequestParams } from './utils';

// 通用API封装方法
const capiFn = (apiList, request) => {
  return {
    async receiveObjectPrize(params) {
      const { handle, method, ext } = getRequestParams(apiList['receiveObjectPrize']);
      const userAddress = await getUserAddress().catch(err => {
        commonToast(err.errorMessage);
      });
      if (userAddress) {
        const { name, phone, address } = userAddress.duibaAddress;
        commonConfirm('提示', '确认使用该收货地址：' + name + phone + address, async () => {
          params = {
            name,
            phone,
            address,
            ...params
          }
          const result = await request(handle, method, params, ext).catch(res => {
            commonToast(res && res.message);
          });
          if (result && result.success) {
            return true;
          }
        });
      }
      return false;
    },
    async receiveEnamePrize(params) {
      const { handle, method, ext } = getRequestParams(apiList['receiveEnamePrize']);
      const result = await request(handle, method, params, ext).catch(res => {
        commonToast(res && res.message);
      });
      if (result && result.success) {
        return true;
      }
      return false;
    }
  }
};


export default capiFn;
