import cloud from '@tbmp/mp-cloud-sdk';
import tbcc from './tbcc-sdk';

cloud.init({
  env: 'test' // 云函数环境 test 测试环境 online 线上环境
});

App({
  requestType: 'ams', // ams：ams接口，cloud: 云函数
  cloudName: 'CommonToC', // 主云函数项目名
  cloud,
  tbcc,
  onLaunch(options) {
    this.handleQuery(options.query || {});
  },
  onShow(options) {
    // 从后台被 scheme 重新打开
  },
  /**
   * 处理链接参数
   * @param {object} query 小程序链接上的参数
   */
  handleQuery(query) {
    const { activityId } = query;
    this.activityId = activityId || 'testId';
  }
});
