/** @format */

import { resultsModel } from '../../../sdk'
import { CODE_TYPES } from '../../../errorCode'
import { ACTIVITY_OPEN_PRIZE_STATUS } from '../../../constants'

// 检查开奖
export default async function checkOpenPrizeStatus(context: IContext<IParams>, { activityInfo }: IControllerInfos) {
  const now = Date.now()
  const { startTime, endTime, openPrizeStatus } = activityInfo
  // 活动未结束
  if (endTime > now) {
    return resultsModel.error(CODE_TYPES.ERROR_ACTIVITY_NO_OVER, '活动未结束')
  }
  if (now < startTime) {
    return resultsModel.error(CODE_TYPES.ERROR_ACTIVITY_NOSTART, `活动未开始`)
  }

  if (openPrizeStatus === ACTIVITY_OPEN_PRIZE_STATUS.SUCCESS) {
    return resultsModel.error(CODE_TYPES.ERROR_ACTIVITY_OPENED_PRIZE, `活动已开奖`)
  }
}
