/** @format */

import { transformBeijingDate, dateFormatter } from '../sdk'

// 获取今天的时间
export const getToday = () => {
  console.log(transformBeijingDate(Date.now()))
  return dateFormatter(transformBeijingDate(Date.now()), 'yyyy/MM/dd')
}

/**
 * 传入时间戳（毫秒）
 * 根据时间戳转换成number型日期进行差值结算，比如：2020318-2020317
 */
export function isNewDay(time: number) {
  let date = new Date(time)
  let dateNum = +(date.getFullYear() + '' + (date.getMonth() + 1) + '' + date.getDate())

  let nowdate = new Date(Date.now())
  let nowdateNum = +(nowdate.getFullYear() + '' + (nowdate.getMonth() + 1) + '' + nowdate.getDate())
  return nowdateNum - dateNum > 0
}

export const formatTime = (thisDate: Date, fmt: string = 'yyyy-MM-dd hh:mm:ss') => {
  var o = {
    'M+': thisDate.getMonth() + 1,
    'd+': thisDate.getDate(),
    'h+': thisDate.getHours(),
    'm+': thisDate.getMinutes(),
    's+': thisDate.getSeconds(),
    'q+': Math.floor((thisDate.getMonth() + 3) / 3),
    S: thisDate.getMilliseconds()
  }
  if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (thisDate.getFullYear() + '').substr(4 - RegExp.$1.length))
  for (var k in o)
    if (new RegExp('(' + k + ')').test(fmt))
      fmt = fmt.replace(RegExp.$1, RegExp.$1.length == 1 ? o[k] : ('00' + o[k]).substr(('' + o[k]).length))
  return fmt
}
