var Buffer = require("buffer").Buffer
var crypto = require("crypto")

const request = ({ cloud, cloudName, requestType = 'cloud', mockUrl }) => {
  console.log(2)
  if (!cloud) {
    console.error('请传入cloud');
    return false;
  }
  if (!cloudName) {
    console.error('请传入云函数名称');
    return false;
  }
  return async (handle, method = 'POST', params, ext = {}) => {
    const { activityId, tornadoAPI, nickName='', tbcc } = getApp();
    // 默认注入activityId
    params = { activityId, ...params };
    if (!params.activityId) {
      console.error(`${handle}:请传入activityId`);
      return false;
    }
    console.log(params, handle)
    const _cloudName = ext.cloudName || cloudName;
    const { isShowLoading } = ext;
    const hideMyLoading = () => {
      if (isShowLoading) {
        my.hideLoading();
      }
    };
    if (isShowLoading) {
      my.showLoading();
    }
  
    const requestMock = () => {
      // 若请求的是风驰台的api
      if (requestType === 'tornadoAPI') {
        // 处理涉及的三个参数
        let matchRes = tornadoAPI.match(/db=(\w*)&proxyIp=([\d]{1,3}\.[\d]{1,3}\.[\d]{1,3}\.[\d]{1,3})/)
        let db = matchRes[1]
        let proxyIp = matchRes[2]
        let data_ = {
          handler: handle,
          data: params
        }
        console.log(`data_`, data_)
        let params_ = {
          db,
          proxyIp,
          data: data_
        }
        console.log(`params_`, params_)
        // nickName 转 md5 作为唯一的openId
        if (!nickName) {
          tbcc.tb.getAuthUserInfo().catch(err => {
            console.log('未授权成功', err);
          }).then(res => {
            cb(res)
          })
        }

        function cb({nickName}) {
          if (!db || !proxyIp) {
            my.confirm({
              title: '风驰台地址错误',
              content: '请确认风驰台的地址是否正确，未查找到db和proxyIp',
              confirmButtonText: '确定',
              cancelButtonText: '取消'
            });
            return false
          }
          params_.openId = md5(nickName)
          return new Promise((resolve, reject) => {
            my.request({
              url: tornadoAPI,
              method: 'post',
              data: params_,
              dataType: 'json'
            }).then(({ data: res }) => {
              console.log(`调用风驰台返回结果`, res)
              hideMyLoading();
              if (res && res.success) {
                resolve(res);
              } else {
                reject(res);
              }
            }).catch((e) => {
              hideMyLoading();
              console.log(e)
              reject();
            });
          })
          function md5(data) {
              var buf = new Buffer(data);
              var str = buf.toString("binary");
              return crypto.createHash("md5").update(str).digest("hex").slice(0, 30);
          }
        }
      } else {
        const mockUrlPrefix = {
          ams: 'https://ams.dui88.com/server/index.php?g=Web&c=Mock&o=simple&projectID=218&uri=',
          yapi: 'https://docs.dui88.com/mock/140/'
        };
        const requestPrefix = mockUrl || mockUrlPrefix[requestType];
        return new Promise((resolve, reject) => {
          my.request({
            url: requestPrefix + _cloudName + '.' + handle,
            method,
            data: params,
            dataType: 'json'
          }).then(({ data: res }) => {
            hideMyLoading();
            if (res && res.success) {
              resolve(res);
            } else {
              reject(res);
            }
          }).catch(() => {
            hideMyLoading();
            reject();
          });
        })
      }
    };

    const requestCloud = () => {
      return new Promise((resolve, reject) => {
        cloud.function.invoke(_cloudName, params, handle).then(res => {
          console.log(handle, params, res);
          hideMyLoading();
          if (res && res.success) {
            resolve(res);
          } else {
            reject(res);
          }
          return res;
        }).catch(() => {
          hideMyLoading();
          reject();
        });
      });
    };
  
    return ['ams', 'yapi', 'tornadoAPI'].includes(requestType) ? requestMock() : requestCloud();
  };
};

export default request;