'use strict';
import API from "/api";
const app = getApp();
const { tbcc } = app;
const { commonToast, navigateToOutside, getUserAddress, setClipboard } = tbcc.tb;
const { PRIZE_TYPE_MAP, PRIZE_DRAW_STATUS_MAP } = tbcc.constants;

let flag = false;

Page({
  data: {
    PRIZE_TYPE_MAP,
    PRIZE_DRAW_STATUS_MAP,
    myPrizeList: null, //我的奖品
    endTime: null,//到期时间
    task: {
      image: {
        bg: '//yun.duiba.com.cn/aurora/assets/e13fab3165d3a6bb4cbe8827e8f0fd41084b0091.png', //背景图
        copyIcon: '//yun.dui88.com/duiba-components-c-myprizemyprize_copy_code.png', //复制
        addressBth: '//yun.dui88.com/duiba-components-c-myprizeto_address.png', //填写地址(实物奖品)
        getBth: '//yun.dui88.com/duiba-components-c-myprizeget_now.png', //立即领取(除实物奖品外)
        logisticsBth: '//yun.dui88.com/duiba-components-c-myprizelogistics.png', //查看物流
        useBth: '//yun.dui88.com/duiba-components-c-myprizeto_use.png', //去使用(除实物奖品外)
        getAgainBtn: '//yun.dui88.com/duiba-components-c-myprizeget_again.png', //重新领取
        invalidBtn: '//yun.duiba.com.cn/spark/assets/914ba8643c8abb8d710a3126ec312aecf6c4daf0.png', //已失效
        failBth: '//yun.duiba.com.cn/spark/assets/8267375232058a6d0140270b1594427fb08d6ae3.png', //领取失败
      },
      logisticsImage: {
        shipped: '//yun.dui88.com/duiba-components-c-myprizeprize_shipped.png', // 已发货物理弹窗
        notShipped: '//yun.dui88.com/duiba-components-c-myprizenotshipped.png', // 待发货物流弹窗
        copyIcon: '//yun.dui88.com/duiba-components-c-myprizemyprize_copy_code.png', //复制
      },
      btnStyle: { // 按钮自定义样式
        width: '150rpx',
        height: '41rpx',
      }
    }
  },
  onShow() {
    flag = false
    this.getMyPrize();
  },
  // 到期时间
  getEndTime(prizeList = []) {
    if (!prizeList || !prizeList.length) return null
    const endTime = prizeList[0].expiredTime
    if (!endTime) return null
    const t1 = new Date(endTime).toLocaleDateString() + '';//获取年月日
    const t2 = new Date(endTime).getHours() + '';//获取时
    const t3 = new Date(endTime).getMinutes() + '';//获取分
    const t4 = new Date(endTime).getMilliseconds() + '';//获取秒
    console.log(endTime, new Date(endTime + 48 * 60 * 60 * 1000).toLocaleString(), 'endTime');
    this.setData({
      endTime: t1 + " " + t2.padStart(2, '0') + ":" + t3.padStart(2, '0') + ":" + t4.padStart(2, '0')
    })
  },

  /**
 * 获取奖品列表
 * @param {string} type 是否展示loading
 */
  async getMyPrize(type) {
    const { activityId } = app;
    if (type != 'noLoading') {
      my.showLoading();
    }
    const { success, data, message } = await API.getMyPrizeList({ activityId }).catch(res => {
      this.setData({
        myPrizeList: []
      })
    }) || {};
    if (success && data) {
      this.setData({
        myPrizeList: data.list
      })
      this.getEndTime(data.list)
    }
    if (type != 'noLoading') {
      my.hideLoading();
    }
  },

  //领取奖品
  async handleClick(e) {
    const { item } = e.target.dataset;
    // 领取权益
    if (item.type === PRIZE_TYPE_MAP.EQUITY) return this.handleGetEquity(e)
    // 领取实物
    if (item.type === PRIZE_TYPE_MAP.ENTITY) return this.handleGetEntity(e)
    // 领取积分
    if (item.type === PRIZE_TYPE_MAP.INTEGRATION) return this.handleGetIntergation(e)
  },
  // 优惠券
  async handleGetEquity(e) {
    if (flag) {
      return
    }
    flag = true;
    const { activityId } = app;
    const { item } = e.target.dataset;
    console.log(item, '领取权益')
    const { success, data, message } = await API.receiveEnamePrize({ activityId, _id: item._id }).catch(res => {
      this.getMyPrize('noLoading')
      commonToast(res && res.message)
    }) || {};
    if (success && data) {
      commonToast('领取成功')
      this.getMyPrize()
    }
    setTimeout(() => {
      flag = false
    }, 500)
  },
  // 领取实物前询问
  async handleGetEntity(e) {
    if (flag) {
      return
    }
    my.showLoading();
    flag = true;
    const { activityId } = app;
    const { item } = e.target.dataset;
    const userAddress = await getUserAddress({ joinTag: " " })
    my.hideLoading();
    if (!userAddress) return
    const { name, telNumber, provinceName, cityName, cityCode, countyName, detailInfo, streetName } = userAddress || {};
    const params = {
      activityId,
      name,
      phone: telNumber,
      addressdetail: detailInfo,
      cityCode,
      city: cityName,
      provice: provinceName,
      area: countyName,
      streetName,
      _id: item._id
    }

    my.confirm({
      title: '提示',
      content: '确认使用该收货地址：' + name + telNumber + userAddress.duibaAddress.address,
      confirmButtonText: '确定',
      cancelButtonText: '取消',
      success: (result) => {
        console.log(result)
        const { confirm } = result;

        if (confirm) {
          this.receiveObjectPrize(params);
        }
      },
    });
    flag = false
  },
  // 领取实物
  async receiveObjectPrize(params) {
    const { success, data, message } = await API.receiveObjectPrize(params) || {}
    if (success && data) {
      commonToast('领取成功')
    } else {
      commonToast(message)
    }
    this.getMyPrize()
  },
  // 积分
  async handleGetIntergation(e) {
    if (flag) {
      return
    }
    flag = true;
    // 判断是否为会员
    await this.getUserInfo()
    const { isVip, vipLink } = app;
    if (!isVip) {
      commonToast('立即加入会员，即可领取奖品', 2000);
      setTimeout(() => {
        navigateToOutside(vipLink)
      }, 1000)
      flag = false
      return
    }
    const { activityId } = app;
    const { item } = e.target.dataset;
    console.log(item, '领取积分')
    const { success, data, message } = await API.receiveEnamePrize({ activityId, _id: item._id }) || {};
    if (success && data) {
      commonToast('领取成功')
    } else {
      commonToast(message)
    }
    flag = false
    this.getMyPrize()
  },

  //获取用户vip信息
  async getUserInfo() {
    const { activityId } = app;
    const { success, data, message } = await API.getVipInfo({ activityId }) || {};
    console.log(data, '用户vip信息');
    if (success && data) {
      app.isVip = (data && data.isVip) || false;
      app.vipLink = (data && data.url) || '';
    } else {
      commonToast(message)
    }
  },
});