const configPackage  = require('../../../package.json')
/**
 * 告警信息
 * @param message 
 */
export const cloundAlarm = async (context: IContext<IParams>, message: string, stack: string) => {
    const { title, author, phone } = configPackage
    const envTxt = {
      'test': '测试环境',
      'pre': '预发环境',
      'online': '线上环境'
    }
    // https://oapi.dingtalk.com/robot/send?access_token= f6d0d8ecdab3ad77dc51b5173f630f1c0e0fcbe90e994d0a642fb0b516dfd24c

    // 测试 d452c99b12d3fe67472c681e76b13ed5b2355c3e2c3b856a1c3a9897a103986b
    const text = {
        "msgtype": "markdown",
        "markdown": {
          "title":"云告警",
          "text": `### 活动名称：${title} \n > #### 环境： ${envTxt[context.env]}\n > #### 告警内容： ${message}\n > #### 详细信息： \n > ${stack}\n\n @${author}`
        },
        "at": { "isAtAll": false, "atMobiles": [], "atUserIds": [] }
    }
    const result = await Promise.all([
      context.cloud.httpApi.invoke(
        {
           'domain':'https://oapi.dingtalk.com',
           'path': '/robot/send',
           'params': {
            'access_token': 'f6d0d8ecdab3ad77dc51b5173f630f1c0e0fcbe90e994d0a642fb0b516dfd24c'
           },
           'method':'POST',
           'headers': {
              'Content-Type':'application/json;charset=UTF-8',
           },
           'body': text
      }),
      context.cloud.httpApi.invoke(
        {
          'domain':'https://oapi.dingtalk.com',
          'path': '/robot/send',
          'params': {
            'access_token': 'f6d0d8ecdab3ad77dc51b5173f630f1c0e0fcbe90e994d0a642fb0b516dfd24c'
          },
          'method':'POST',
          'headers': {
              'Content-Type':'application/json;charset=UTF-8',
          },
          'body': {
            "msgtype": "text",
            "at": { "isAtAll": false, "atMobiles": [ phone ], "atUserIds": [] },
            "text": { 'content': '云告警'}
          }
      })
    ])
    return result
}