import { TASK_RATE_TYPE } from "../const";
import flatten from "lodash/flatten";
import { rankTableValidator } from "../../../utils/validate";

// 使用 async-validator 校验
// 文档地址: https://github.com/yiminghe/async-validator
export const descriptor = {
  title: {
    required: true,
    validator: (rule, value) => {
      value = value.trim();
      return !!value && value.length <= 12;
    },
    message: "请输入正确的活动名称",
  },

  subtitle: {
    required: true,
    validator: (rule, value) => {
      value = value.trim();
      return !!value && value.length <= 16;
    },
    message: "请输入正确的活动副标题",
  },
  prizeInfoList: {
    required: true,
    validator: rankTableValidator,
  },
  //活动的开始时间和结束时间校验判断
  timeRange: {
    required: true,
    validator: (rule, value) => {
      if (!value[0] || !value[1]) {
        return new Error("请完整配置活动时间");
      }
      if (+value[0] >= +value[1]) {
        return new Error("活动开始时间不得大于活动结束时间");
      }
      if (+value[0] < Date.now() && +value[1] < Date.now()) {
        return new Error("活动结束时间不得小于当前时间");
      }
      return true;
    },
    // message: "请输入正确的活动时间"
  },
  logoImg: {
    required: true,
    message: "请配置图片",
  },
  commandTitle: {
    required: true,
    validator: (rule, value) => {
      value = value.trim();
      return !!value;
    },
    message: "请输入淘口令名称",
  },
  beenInvitedText: {
    required: true,
    validator: (rule, value) => {
      value = value.trim();
      return !!value;
    },
    message: "请输入被邀请者文案",
  },
  commandImg: {
    required: true,
    message: "请输入淘口令图片",
  },
  rule: {
    required: true,
    validator: (rule, value) => {
      value = value.trim();
      return !!value;
    },
    message: "请输入活动规则",
  },
  taskMap: {
    type: "object",
    required: true,
    fields: {
      member: {
        validator: (rule, val, cb, source) => {
          if (!source.member.checked) return true;
          return !!val.value;
        },
        message: "请输入成为会员任务的奖励",
      },
      invites: {
        validator: (rule, val, cb, source) => {
          if (!source.invites.checked) return true;
          return !!(val.title && val.value);
        },
        message: "请输入邀请任务",
      },
      jumpLink: {
        validator: (rule, val, cb, source) => {
          if (!source.jumpLink.checked) return true;
          return !!(val.title && val.value && val.link);
        },
        message: "请输入浏览指定页面任务",
      },
      browseGoods: {
        validator: (rule, val) => {
          return !!val.itemIds;
        },
        message: "请输入寻宝屋商品任务",
      },
    },
  },
};

export const formatValidator = (descriptor, validators) => {
  validators = validators || {};
  Object.keys(descriptor).forEach((key) => {
    if (descriptor[key].fields) {
      Object.keys(descriptor[key].fields).forEach((fieldKey) => {
        validators[`${key}.${fieldKey}`] = {
          status: "success",
          message: "",
        };
      });
    } else {
      validators[key] = {
        status: "success",
        message: "",
      };
    }
  });
  return validators;
};
