/** @format */
import { BaseDao } from '../sdk'
import { ERROR_LOG_DB_NAME } from '../db'
import { getToday } from '../utils'

export const logger = (context: Context) => {
  const data = JSON.stringify(context.data)
  console.log(context)
  console.log(
    `---------函数: ${context.fcName || ''}.${
      context?.cloud?.dataspace?.context?.handler || context.handler
    }------------`
  )
  console.log(`---------请求参数: ${data}------------`)
}

// 记录错误日志
export const recordErrorLog = async (
  context: Context,
  baseInfos: IControllerInfos,
  errorMsg: string,
  stack: string
) => {
  const { openId, userNick } = context
  const { activityId } = context.data || {}
  const logdao: IBaseDao = new BaseDao(context, ERROR_LOG_DB_NAME)
  const functionName: string = `${context.fcName || ''}.${
    context?.cloud?.dataspace?.context?.handler || context.handler
  }`
  return await logdao.insertOne({
    openId,
    activityId,
    errorMsg,
    errorStack: stack,
    functionName,
    userNick,
    fcInvokeId: context.fcInvokeId,
    params: context.data,
    createTime: Date.now(),
    createDay: getToday(),
    catchType: 1
  })
}
