import API from '@/api'
import { useThrottle } from '@/hooks/useThrottle'
import { useState, useEffect, useRef } from 'react'
import { useDidShow, showToast } from '@tarojs/taro'
import { useLoginInfoModel } from '@/store'
import { checkIsMember } from 'tbcc-sdk-ts/lib/utils'
import { navigateTo, favorShop, checkShopFavoredStatus, navigateToOutside, showSharePanel, navigateToTaobaoPage } from 'tbcc-sdk-ts/lib/core/tb'
import { TASK_DATA } from '@/mock'
import { SHOP_ID } from '@/const'
import config from '@/config/config'
import { TASK_CONFIG, ORDER_GOOD_TYPE, BROSE_GOOD_TYPE, TASK_STATUS, TASK_SHOW_TYPE } from '@/config/task.config'

const { jumpType, browseTime, showTaskType, browseType, orderType, successMsg, isMock = false, browseGoodType } = TASK_CONFIG
export function useTasks(props) {
  const { onUpdate } = props
  const app = getApp()
  const { loginInfo } = useLoginInfoModel()
  const [ taskList, setTaskList ] = useState(isMock ? TASK_DATA : [])

  const [ currentTaskType, setCurrentTaskType ] = useState('')
  const preBrowseTime = useRef(null)
  // 页面显示
  useDidShow(() => {
    if (app.isFlashTask) {
      app.isFlashTask = false
      if (preBrowseTime.current && ((Date.now() - preBrowseTime.current) / 1000) >= browseTime && currentTaskType !== browseGoodType) {
        doCompleteTaskHandle(currentTaskType)
        preBrowseTime.current = null
      } else if(preBrowseTime.current && ((Date.now() - preBrowseTime.current) / 1000) < browseTime) {
        showToast({ title: `未达到${browseTime}秒~`})
        preBrowseTime.current = null
      }else {
        fetchTaskList()
      }
    }
  })
  // 数据初始化
  useEffect(() => {
    if(showTaskType === TASK_SHOW_TYPE.LIST && loginInfo.isLogin) {
      fetchTaskList()
    }else if(showTaskType === TASK_SHOW_TYPE.MODAL){
      fetchTaskList()
    }
  },[loginInfo])
  // 任务数据获取
  const fetchTaskList = async () => {
    const isVip = await checkIsMember()
    const { success, data } = await API.getTaskList({ isVip })
    if(success && data) {
      const { list = [] } = data
      const _list = list.map(itm => {
        return {
          ...itm,
          rateType: itm?.rateType || itm?.taskRateType,
          reward: itm?.reward || itm?.rewards,
          key: itm?.key || itm?.taskType,
          name: itm?.name || itm?.title,
        }
      })
      setTaskList(_list)
    }
  }
  // 点击任务项
  const handleItem = useThrottle(async(item, callbackFn) => {
    const { status, key } = item
    const tapFn = {
      [TASK_STATUS.WAIT_RECEIVE]: async() => {
        const { success, data } = await API.receiveTask({ key, rewardsKey: TASK_CONFIG.rewardsKey })
        if (success && data) {
          const { rewards } = data
          showToast({ title: `${successMsg}${rewards}` })
          fetchTaskList()
          onUpdate && onUpdate()
        }
      },
      [TASK_STATUS.WAIT_DO]: () => completeTask(item, callbackFn)
    }
    tapFn[status] && tapFn[status]()
  })
  // 完成任务处理
  const completeTask = async(item, callbackFn = () => {}) => {
    const { key, url, itemIds, keepTime } = item
    setCurrentTaskType(key)
    const completeFn = {
      member: async () => {
        const isVip = await checkIsMember()
        if(!isVip) {
          callbackFn()
          return;
        }
        doCompleteTaskHandle(key,isVip)
      },
      invite: () => showSharePanel(),
      follow: async () => {
        // 已关注店铺直接完成任务
        const isFollow = await checkShopFavoredStatus(config.sellerId)
        if (isFollow) {
          doCompleteTaskHandle(key)
          return;
        }
        // 未关注店铺直接关注并完成任务
        const checkFollow = await favorShop(config.sellerId)
        if(checkFollow) {
          doCompleteTaskHandle(key)
          return;
        }
      },
      // 跳转任务 https://www.feizhu.com
      jump: async() => {
        navigateToOutside(url)
        if (jumpType === 2) {
          doCompleteTaskHandle(key)
        } else {
          app.isFlashTask = true
          preBrowseTime.current = Date.now()
        }
        // await API.addStat({ type: 'BROWSE_LIVE'})
      },
      browse: async() => {
        app.isFlashTask = true
        if(browseType === BROSE_GOOD_TYPE.PAGE) preBrowseTime.current = Date.now()
        navigateTo(`/pages/packageGood/browseGoods/browseGoods?itemIds=${itemIds}&keepTime=${keepTime}`)
      },
      order: async() => {
        app.isFlashTask = true
        if(orderType === ORDER_GOOD_TYPE.PAGE) {
          navigateTo(`/pages/packageGood/orderGoods/orderGoods?itemIds=${itemIds}`)
        }else {
          await navigateToTaobaoPage(SHOP_ID)
        }
      },
      collect: async() => {
        app.isFlashTask = true
        navigateTo(`/pages/packageGood/collectGoods/collectGoods?itemIds=${itemIds}`)
      },
      addCart: async() => {
        app.isFlashTask = true
        navigateTo(`/pages/packageGood/cartGoods/cartGoods?itemIds=${itemIds}`)
      },
      sign: () => doCompleteTaskHandle(key),
      share: () => {
        showSharePanel();
        setTimeout(() => {
          doCompleteTaskHandle(key)
        }, 2000);
      }
    }
    completeFn[key] && completeFn[key]()
  }
  // 完成任务接口调用
  const doCompleteTaskHandle = async(key,isVip) => {
    const { success } = await API.completeTask({ key, taskType: key, isVip })
    if (success) {
      await fetchTaskList()
    }
  }
  return {
    taskList,
    handleItem,
    fetchTaskList
  }
}
