const fs = require('fs');
const path = require('path')
const { canvasPages, hasCanvas } = require('../config/default').default

export default (ctx, options) => {
    // plugin 主体
    ctx.onBuildStart(() => {
        // console.log('编译开始！')
    })
    ctx.onBuildFinish(() => {
        if(hasCanvas) {
            for(let i = 0; i < canvasPages.length; i++) {
                const itm = canvasPages[i]
                const dirUrl = path.resolve(__dirname,'..')+`/dist/${itm.root}`
                const rawdata = fs.readFileSync(dirUrl);
                const { usingComponents, ...ext } = JSON.parse(rawdata);
                const new_info = {
                    ...ext,
                    usingComponents: {
                        ...usingComponents,
                        "canvas-comp": `/${itm.comRoot}`
                    }
                }
                fs.writeFileSync(dirUrl, JSON.stringify(new_info));
            }
        }
        console.log('文件写入成功！');
        //ctx.writeFileToDist({ filePath: string, content: string })
    })
}