import React, { useEffect, useRef, useState } from 'react'
import { View } from '@tarojs/components'
import ContainerFit from '@/components/_base/ContainerFit/ContainerFit'
import GoodsTitle from '@/components/_tb_comps/TitleImg/TitleImg'
import GoodsList from '@/components/_tb_comps/GoodsList/GoodsList'
import BrowserLoading from '@/components/_tb_comps/BrowserLoading/BrowserLoading'
import { useDidShow, useRouter, useDidHide, showToast } from '@tarojs/taro'
import API from '@/api'
import styles from './browseGoods.module.less'
import { TASK_CONFIG, BROSE_GOOD_TYPE } from '@/config/task.config'
import { BROWSE_CONFIG } from '@/config/browse.config'
import { GOOD_LIST } from '@/mock'

function BrowseGoodsPage() {
  const { params: { itemIds, keepTime } } = useRouter()
  const { browseType, browseTime = 15 } = TASK_CONFIG
  
  const [ startTimer, setStartTimer ] = useState(false)
  const preBrowseTime = useRef(null)
  const currentItemId = useRef('')
  const usePercent = useRef(0)
  const [accumulateTime, setAccumulateTime] = useState(+keepTime || 15)

  const browserTimer = useRef(null)
  const [goodsList, setGoodsList] = useState(BROWSE_CONFIG.isMock?GOOD_LIST:[])
  
  useEffect(() => {
    getGoodsList()
  }, [])
  // 浏览集合页15s
  useEffect(() => {
    if(browseType === BROSE_GOOD_TYPE.PAGE) {
      (!browserTimer.current && goodsList.length) && browseGoodsTimes()
      return () => browserTimer.current && clearInterval(browserTimer.current)
    }
  },[goodsList])
  // 获取商品列表
  const getGoodsList = async () => {
    const { success, data } = await API.getCollectGoods({ key: BROWSE_CONFIG.taskType, itemIds, taskType: BROWSE_CONFIG.taskType })
    if(success && !BROWSE_CONFIG.isMock ) {
      setGoodsList(data?.list || [])
    }
  }
  // 页面显示
  useDidShow(() => {
    // 重新回到页面开启倒计时
    if(browseType === BROSE_GOOD_TYPE.PAGE && startTimer && usePercent.current < +browseTime) {
      browseGoodsTimes()
    }
    console.warn('回到该页面了')
    if (browseType === BROSE_GOOD_TYPE.DETAIL && preBrowseTime.current && ((Date.now() - preBrowseTime.current) / 1000) >= browseTime) {
      onCompleteTask()
      currentItemId.current = ''
      preBrowseTime.current = null
    } else if(preBrowseTime.current) {
      showToast({ title: `未达到${browseTime}秒~`})
      currentItemId.current = ''
      preBrowseTime.current = null
    }
  })
  useDidHide(() => {
    // 页面关闭清除定时器
    if(browserTimer.curren) {
      clearInterval(browserTimer.current)
      setStartTimer(true)
    }
  })
  // 浏览记录
  const onCompleteTask = async(itemId) => {
    const { success } = await API.completeTask({ key: BROWSE_CONFIG.taskType, itemId: currentItemId.current, taskType: BROWSE_CONFIG.taskType })
    if (success) {
      getGoodsList()
      showToast({ title: '浏览成功'})
    }
  }
  // 点击商品 跳转时处理
  const onOpenDetail = (itemId, collected) => {
    const handleFn = {
      [BROSE_GOOD_TYPE.PAGE]: () => {
        setStartTimer(true)
        clearInterval(browserTimer.current)
        return;
      },
      [BROSE_GOOD_TYPE.CLICK]: () => {
        currentItemId.current = itemId
        onCompleteTask()
      },
      [BROSE_GOOD_TYPE.DETAIL]: () => {
        if(collected) {
          showToast({ title: '该商品已经浏览过了'})
          return;
        }
        preBrowseTime.current = Date.now()
        currentItemId.current = itemId
      }
    }
    handleFn[browseType]()
  }
  // 浏览页面定时器
  const browseGoodsTimes = () => {
    browserTimer.current = setInterval(() => {
      const keepTime_ = browseTime
      console.log('enter the browse time ');
      usePercent.current += 1
      setAccumulateTime(+keepTime_ - usePercent.current)
      console.warn(usePercent.current,keepTime_)
      if (usePercent.current >= keepTime_) {
        onCompleteTask()
        clearInterval(browserTimer.current)
        usePercent.current = 0
        setAccumulateTime(0)
      }
    }, 1000)
  }
  return (
    <ContainerFit bg={BROWSE_CONFIG.bg}>
      <View className={styles['page-content__title']}>
        <GoodsTitle config={BROWSE_CONFIG.head}/>
      </View>
      <View className={styles['page-content__list']}>
        <GoodsList goodsList={goodsList} task={BROWSE_CONFIG} onOpenDetail={(itemId,collected) => onOpenDetail(itemId,collected)} />
      </View>
      {
        BROWSE_CONFIG.countDown && 
        <BrowserLoading loadFlag={BROWSE_CONFIG.countDown} count={accumulateTime} />
      }
    </ContainerFit>
  )
}
export default BrowseGoodsPage


