import React, { useRef, useState, useEffect } from 'react'
import { View, Image } from '@tarojs/components'
import { useShareAppMessage, useDidShow, getApp, showToast } from '@tarojs/taro'
import classnames from 'classnames'
import { SHARE_CONFIG } from '@/const.js'
import { HELP_MODAL_TYPE } from '@/config/help.config'
import { useLogin, useLoginFromShare } from '@/hooks/useLogin'
import { useActivityInfoModel, useLoginInfoModel } from '@/store'
import API from '@/api'
import ContainerFit from '@/components/_base/ContainerFit/ContainerFit'
import RuleModal from '@/components/_tb_modal/RuleModal/RuleModal'
import DoHelpModal from '@/components/_tb_modal/DoHelpModal/DoHelpModal'
import TasksModal from '@/components/_tb_modal/TasksModal/TasksModal'
import JackpotModal from '@/components/_tb_modal/JackpotModal'
import Auth from '@/components/_tb_modal/Auth/Auth'
import styles from './index.module.less'
import tbcc from 'tbcc-sdk-ts'
const { navigateTo, openDetail, showSharePanel } = tbcc.tb
const { getImgShareUrl, checkIsMember, validateActivityStatus } = tbcc.utils

import {useAudio} from '@/hooks/useAudio'

import {CLOUD_OBJ, BGMUSIC_URL} from '@/const'

const INDEX_CONFIG = {
  bg: '', // 背景 cloud://C4015B7CEC23CF013A78247E2852524F//火箭待机小球抖动.json
  ruleButton: '', // 规则按钮
  myPrizeButton: '', // 我的奖品按钮
  shareButton: '', // 分享按钮
  taskButton: '' // 任务按钮
}
const prizeItem = {
  id: "6115fc6a3075d9bde4b16a53",
  image: "https://img.alicdn.com/imgextra/i4/353042333/O1CN012k7gbk1T6YigovFNu_!!353042333-0-isvtu.jpg",
  type: 3,
  name: '测试i奖品'
}

function Index() {
  const app = getApp()
  const { activityInfo, setActivityInfoAndStatus } = useActivityInfoModel()
  const { loginInfo } = useLoginInfoModel()

  const [ memberVisible, setMemberVisible ] = useState(false)
  const [ doHelpModalVisible, setDoHelpModalVisible ] = useState(false)
  const [ ruleModalVisible, setRuleModalVisible ] = useState(false)
  const [ tasksModalVisible, setTasksModalVisible ] = useState(false)
  // 中奖弹窗
  const [ prizeModalVisible, setPrizeModalVisible] = useState(false)
  // 分享图
  const SHARE_IMG = useRef('')
  // 助力弹窗类型
  const [helpType,setHelpType] = useState(HELP_MODAL_TYPE.HELP)
  // 助力弹窗类型
  const [helpInfo,setHelpInfo] = useState({})
  // 助力弹窗标识
  const showHelp = useRef(false)

  const fetchActivityInfo = async() => {
    const { success, data } = await API.getActivityBaseInfoById()
    if(success) {
      const { startTime, endTime, rule } = data
      setActivityInfoAndStatus({
        startTime, endTime,  rule
      })
    }
  }
  // 获取用户信息
  const fetchUserInfo = async () => {
    const { success, data } = await API.getUserInfo()
    success && setUserInfo(data)
  }
  useEffect(() =>{
    fetchActivityInfo()
    // getImgShareUrl('cloud://CEFE74AE67921906B5AF842150646D35/share.png').then(url => {
    //   SHARE_IMG.current = url
    // })
  },[])
  // 授权登录完成
  const { isLogin, authInfo } = useLogin(async (info) => {
    handleVisibleModal(info)
  })
  // 查看是否有助力信息
  const getShareInfo = async () => {
    const { success, data } = await API.getShareInfo()
    if(success && data && data?.inviteCount) {
      setHelpInfo(data)
      setDoHelpModalVisible(true)
      setHelpType(HELP_MODAL_TYPE.REWARDS)
    }
  }
  // 分享链接进入活动
  useLoginFromShare((inviteId) => {
    console.log('inviteId :>> ', inviteId)
    app.inviteId = inviteId
  })

  useShareAppMessage(() => {
    return {
      ...SHARE_CONFIG,
      imageUrl: SHARE_IMG.current,
      path: `pages/index/index?inviteId=${loginInfo.openId}`
    }
  })
  // 助力弹窗 -> 其他弹窗
  const handleVisibleModal = async (info) => {
    const { inviteId } = info
    const isVip = await checkIsMember()
    // 是否为助力弹窗
    if(inviteId && !showHelp.current) {
      setDoHelpModalVisible(true)
      setHelpType(isVip? HELP_MODAL_TYPE.FAIL: HELP_MODAL_TYPE.HELP)
      showHelp.current = true
      return;
    }
    // 其他弹窗
  }
  const onClose = () => {
    setMemberVisible(false)
  }
  const onAuthSuccess = () => {
    setMemberVisible(false)
  }
  const onAuthFail = () => {
    setMemberVisible(false)
  }

  const onHandleClose = () => { 
    setDoHelpModalVisible(false)
    if(loginInfo.newUser) {
      handleVisibleModal(loginInfo)
    }
    if(helpType === HELP_MODAL_TYPE.REWARDS) {
      fetchUserInfo()
    }
  }

  const onHandleIndex = (type,updateActInfo) => {
    const Fn = {
      'updateUserInfo': () => {
        fetchUserInfo()
        updateActInfo && fetchActivityInfo()
      },
      'rule': () => setRuleModalVisible(true),
      'prize': () => {
        navigateTo('/pages/packagePrize/myPrize/myPrize')
      },
      'game': () => navigateTo('/pages/packageGame/game/game'),
      'comps': async () => {
        navigateTo('/pages/packageComs/comsTest/comsTest')
      }
    }
    Fn[type]()
  }

  return (
    <>
      <ContainerFit hasFitPsd={true} bg={INDEX_CONFIG.bg}>
        <View className={styles.rule} style={{ backgroundImage: `url(${INDEX_CONFIG.ruleButton})` }} onClick={() => setRuleModalVisible(true)}>活动规则</View>
        <View className={styles.my_prize} style={{ backgroundImage: `url(${INDEX_CONFIG.myPrizeButton})` }} onClick={() => onHandleIndex('prize')}>我的奖品</View>
        <View className={styles.tasks} onClick={() => setTasksModalVisible(true)}>任务</View>
        <View className={styles.games} onClick={() =>onHandleIndex('game') }>游戏</View>
        <View className={styles.bemember} onTap={() => setMemberVisible(true)}>入会</View>

        <View className={styles.comps} onClick={() => onHandleIndex('comps')}>组件预览</View>

        <View className={styles['prize_modal_btn']} onTap={()=>setPrizeModalVisible(true)}>中奖弹窗</View>
      </ContainerFit>
      {/* 中奖弹窗 */}
      {
        prizeModalVisible &&
          <JackpotModal 
            closePostion='bottom'
            bg=''
            width='600'
            height='700'
            top='45%'
            prizeItem={prizeItem}
            onClose={() => setPrizeModalVisible(false)}
          />
      }
      {
        tasksModalVisible &&
          <TasksModal
            onUpdate={() => { console.warn('任务数据更新了')}}
            onClose={() => setTasksModalVisible(false)}
          />
      }
      {
        ruleModalVisible &&
          <RuleModal
            closePostion='bottom'
            bg=''
            width='500'
            height='300'
            rule={activityInfo.rule}
            onClose={() => setRuleModalVisible(false)}
          />
      }
      {
        doHelpModalVisible &&
          <DoHelpModal
            closePostion='bottom'
            bg=''
            width='500'
            height='500'
            top='45%'
            newVip={false}
            onClose={() => setDoHelpModalVisible(false)}
          />
      }
      {<member-modal expend={memberVisible} onClose={onClose} onAuthFail={onAuthFail} onAuthSuccess={onAuthSuccess} />}
      {authInfo?.visible && <Auth clickAuthBtn={authInfo.openSettingFn} /> }
      {false && <canvas-comp />}
    </>
  )
}

export default Index
