function debounce(fn, wait) {
  var timeout = null;
  return function () {
    if (timeout !== null) clearTimeout(timeout);
    timeout = setTimeout(fn, wait);
  };
}
// 域名
const passUrlList = [
  '1688.cn',
  '1688.com',
  'alibaba.cn',
  'alibaba.com',
  'aliexpress.com',
  'alimama.cn',
  'alimama.com',
  'alipay.com.cn',
  'alipay.com',
  'alipay.net',
  'aliplay.com',
  'alisoft.cn',
  'alisoft.com',
  'aliyun.com',
  'aliyun.net',
  'koubei.cn',
  'koubei.com',
  'taobao.cn',
  'taobao.com',
  'taobao.net',
  'tb.cn',
  'tmall.com',
  'zhifu.com',
  'zhifubao.com',
  'juhuasuan.com',
  'tmall.hk',
  'tmall.com.hk',
  'jiyoujia.com',
  'pailitao.com',
  'cainiao.com',
  'dingtalk.com',
  'yushanfang.com',
  'guoguo-app.com',
  'alihealth.cn',
  'miaostreet.com',
  'uc123.com',
  'uc.cn',
  'ucweb.com',
  'aliyun-inc.com',
  'cainiaoyizhan.com',
  'umeng.com',
  'aliplus.com',
  'aliplay.com',
  'taopiaopiao.com',
  'youku.com',
  'tudou.com',
  'xinlingshou.cn',
  'fliggy.com',
  'feizhu.com',
  'feizhu.cn'
];
//判断网站域名
const urlCheck = (link, passUrlList) => {
  if (!link) {
    return {
      status: false,
      message: "请配置链接",
    }
  }
  if (!link.startsWith("http://") && !link.startsWith("https://")) {
    return {
      status: false,
      message: "链接必须以https://或http://开头",
    };
  }
  let passUrl = false;
  passUrlList.some((i) => {
    if (~link.indexOf(i)) {
      passUrl = true;
      return true;
    }
    return false;
  });
  if (!passUrl)
    return {
      status: false,
      message: "域名校验不通过",
    };
  return {
    status: true,
    message: "",
  };
};
// 解决小数相加精度问题
function addFloat(num1, num2) {
  var r1, r2, m;
  r1 = num1.toString().split(".")[1] ? num1.toString().split(".")[1].length : 0;
  r2 = num2.toString().split(".")[1] ? num2.toString().split(".")[1].length : 0;
  m = Math.pow(10, Math.max(r1, r2));
  return (num1 * m + num2 * m) / m;
}

// 小数相除
const accMul = function (arg1, arg2) {
  var m = 0,
    s1 = arg1.toString(),
    s2 = arg2.toString();
  try {
    m += s1.split(".")[1].length;
  } catch (e) { }
  try {
    m += s2.split(".")[1].length;
  } catch (e) { }
  return (
    (Number(s1.replace(".", "")) * Number(s2.replace(".", ""))) /
    Math.pow(10, m)
  );
};
// 小数相乘
const signFigures = function (num, rank = 6) {
  if (!num) return 0;
  const sign = num / Math.abs(num);
  const number = num * sign;
  const temp = rank - 1 - Math.floor(Math.log10(number));
  let ans;
  if (temp > 0) {
    ans = parseFloat(number.toFixed(temp));
  } else if (temp < 0) {
    ans = Math.round(number / Math.pow(10, temp)) * temp;
  } else {
    ans = Math.round(number);
  }
  return ans * sign;
};

// 概率奖品配置 properiodfrom  properiodto
const setPrizeProbalityRange = (prizes) => {
  let originPeriod = 1
  return prizes.map(v => {
    if (!v.probability) return v
    // 概率为0 跳出10000之外的区间
    if (+v.probability === 0)
      return {
        ...v,
        properiodfrom: 1000000,
        properiodto: 1000000
      }
    const properiodfrom = originPeriod
    const properiodto = +originPeriod + signFigures(+v.probability * 100) - 1
    originPeriod = +originPeriod + signFigures(+v.probability * 100)
    return {
      ...v,
      properiodfrom,
      properiodto
    }
  })
}
module.exports = {
  passUrlList,
  signFigures,
  debounce,
  accMul,
  addFloat,
  urlCheck,
  setPrizeProbalityRange
};
