
import Taro from '@tarojs/taro';
import * as configPackage from '../../package.json'
/**
 * 告警信息
 * @param message 
 */
export const cloundAlarm = async (message, env, requestType) => {
    const { title, author, phone } = configPackage
    const envTxt = {
      'test': '测试环境',
      'pre': '预发环境',
      'online': '线上环境',
      'local': '本地环境'
    }

    if(requestType !== 'cloud') return
    // https://oapi.dingtalk.com/robot/send?access_token= f6d0d8ecdab3ad77dc51b5173f630f1c0e0fcbe90e994d0a642fb0b516dfd24c

    // 测试 d452c99b12d3fe67472c681e76b13ed5b2355c3e2c3b856a1c3a9897a103986b
    const text = {
        "msgtype": "markdown",
        "markdown": {
          "title":"小程序客户端云告警",
          "text": `### 活动名称：${title} \n > #### 来源：小程序Taro客户端\n > \n > #### 环境： ${envTxt[env]}\n > #### 告警内容： ${message}\n > @${author}`
        },
        "at": { "isAtAll": false, "atMobiles": [], "atUserIds": [] }
    }
    await Taro.request(
      {
        'url':'https://oapi.dingtalk.com/robot/send?access_token=f6d0d8ecdab3ad77dc51b5173f630f1c0e0fcbe90e994d0a642fb0b516dfd24c',
        'method':'POST',
        'header': {
          'content-type':'application/json;charset=UTF-8',
        },
        'data': text
      }
    );
    Taro.request(
      {
        'url':'https://oapi.dingtalk.com/robot/send?access_token=f6d0d8ecdab3ad77dc51b5173f630f1c0e0fcbe90e994d0a642fb0b516dfd24c',
        'method':'POST',
        'header': {
          'content-type':'application/json;charset=UTF-8',
        },
        'data': {
          "msgtype": "text",
          "at": { "isAtAll": false, "atMobiles": [ phone ], "atUserIds": [] },
          "text": { 'content': '云告警↑↑↑↑↑'}
        }
      }
    );
}