"use strict";
/** @format */
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatTime = exports.isNewDay = exports.getToday = void 0;
var sdk_1 = require("../sdk");
// 获取今天的时间
var getToday = function () {
    console.log(sdk_1.transformBeijingDate(Date.now()));
    return sdk_1.dateFormatter(sdk_1.transformBeijingDate(Date.now()), 'yyyy/MM/dd');
};
exports.getToday = getToday;
/**
 * 传入时间戳（毫秒）
 * 根据时间戳转换成number型日期进行差值结算，比如：2020318-2020317
 */
function isNewDay(time) {
    var date = new Date(time);
    var dateNum = +(date.getFullYear() + '' + (date.getMonth() + 1) + '' + date.getDate());
    var nowdate = new Date(Date.now());
    var nowdateNum = +(nowdate.getFullYear() + '' + (nowdate.getMonth() + 1) + '' + nowdate.getDate());
    return nowdateNum - dateNum > 0;
}
exports.isNewDay = isNewDay;
var formatTime = function (thisDate, fmt) {
    if (fmt === void 0) { fmt = 'yyyy-MM-dd hh:mm:ss'; }
    var o = {
        'M+': thisDate.getMonth() + 1,
        'd+': thisDate.getDate(),
        'h+': thisDate.getHours(),
        'm+': thisDate.getMinutes(),
        's+': thisDate.getSeconds(),
        'q+': Math.floor((thisDate.getMonth() + 3) / 3),
        S: thisDate.getMilliseconds()
    };
    if (/(y+)/.test(fmt))
        fmt = fmt.replace(RegExp.$1, (thisDate.getFullYear() + '').substr(4 - RegExp.$1.length));
    for (var k in o)
        if (new RegExp('(' + k + ')').test(fmt))
            fmt = fmt.replace(RegExp.$1, RegExp.$1.length == 1 ? o[k] : ('00' + o[k]).substr(('' + o[k]).length));
    return fmt;
};
exports.formatTime = formatTime;
//# sourceMappingURL=time.js.map