/** @format */

export const noCatch = (target: any, name: string, descriptor: PropertyDescriptor) => {
  const method = descriptor.value
  descriptor.value = async function (...args: any[]) {
    const [context, otherArgs = {}] = args
    return method.apply(this, [context, { ...otherArgs, noCatch: true }])
  }
}
