/**
 * 创建音频类
 */
class AudioModel {
  constructor(opts = {}) {
    const { src } = opts;
    if (!src) {
      console.error("请输入音频链接");
      return false;
    }
    try {
      const innerAudioContext = my.createInnerAudioContext();
      Object.keys(opts).forEach(item => {
        innerAudioContext[item] = opts[item];
      });
      return innerAudioContext;
    } catch (e) {
      console.error("当前版本不支持音频");
    }
  }
}
/**
 * 创建音频实例
 * @param {object} opts 配置对象 例 { src: '音频链接', autoplay: false }
 */
export const createAudio = opts => {
  const audioInstance = new AudioModel(opts);
  return audioInstance;
};

/**
 * 获取系统信息
 * @returns {object} 小程序系统信息
 */
export const getSystemInfo = () => {
  return new Promise((resolve, reject) => {
    my.getSystemInfo({
      success: res => {
        resolve(res);
      },
      fail: err => {
        reject(err);
      }
    });
  });
};

let bgs = {};
export const playBgMusic1 = async (
  isOn,
  src,
  callbackFn = () => {},
  loop = false
) => {
  //待测试

  for (let k in bgs) {
    if (bgs[k].isOn) {
      bgs[k].stop();
    }
    // bgs[k].isOn = false;	/// TODO 自己记一个开关，因为淘宝的玩意stop之后虽然听不到，但还是在播放，会触发loop播放和onEnded事件
  }

  const key = src;
  console.log("---------->>>>>>>>>>>>>ison", isOn);
  if (isOn) {
    if (!bgs[key]) {
      console.log("enter inner before the createAudio function", src, loop);
      bgs[key] = createAudio({
        src: src,
        autoplay: true,
        loop: loop /// TODO 暂时无效？2020.08.12 目前有效，但stop后还会跑数据，导致到音频结束到时间又自动播放
      });

      console.log("----------------src", src, bgs[key], "bgs[key]");

      bgs[key].onPlay(() => {
        bgs[key].isOn = true;
      });

      bgs[key].onStop(() => {
        bgs[key].isOn = false;
      });

      const systemInfo = await getSystemInfo();

      console.log(systemInfo, "systemInfo-------systemInfo");

      /// TODO监听结束，因为loop无效  2020.08.12 loop有效，这个操作是为了解决stop之后还会跑音频数据的问题
      bgs[key].onEnded(() => {
        if (bgs[key].isOn) {
          // 判断自己记录的开关
          if (systemInfo?.platform.includes("Android")) {
            // 安卓
            bgs[key].play();
          } else if (
            systemInfo?.platform.includes("iOS") ||
            systemInfo?.platform.includes("iPhone OS ")
          ) {
            // ios
            bgs[key].isOn = false;
          }
          delete bgs[key];
          callbackFn && callbackFn();
        }
      });
      bgs[key].play(); // 安卓有时候autoplay好像莫得用
      // console.log(src)
      // bgs[key].isOn = true;	/// TODO 自己记一个开关，因为淘宝的玩意stop之后虽然听不到，但还是在播放，会触发loop播放和onEnded事件
    } else {
      console.log("---------->>>>>>>>>>>>>not enter ");

      bgs[key].play();
      // bgs[key].isOn = true;	/// TODO 自己记一个开关，因为淘宝的玩意stop之后虽然听不到，但还是在播放，会触发loop播放和onEnded事件
      callbackFn && callbackFn();
    }
  } else {
    if (bgs[key]) {
      // bgs[key].pause();	/// pause 垃圾，不能用
      console.log("test stop function is work or not");
      bgs[key].stop();
      // bgs[key].isOn = false;	/// TODO 自己记一个开关，因为淘宝的玩意stop之后虽然听不到，但还是在播放，会触发loop播放和onEnded事件
      callbackFn && callbackFn();
    } else {
      callbackFn && callbackFn();
    }
  }
};
