import React, { useRef, useState } from 'react'
import { View, Image } from '@tarojs/components'
import Taro, { useShareAppMessage, useDidShow, getApp } from '@tarojs/taro'
import classnames from 'classnames'
import { SHARE_CONFIG, HELP_MODAL_TYPE, HELP_MODAL_SHOW } from '@/const.js'
import { useLogin, useLoginFromShare } from '@/hooks/useLogin'
import { useActivityInfoModel, useLoginInfoModel } from '@/store'
import API from '@/api'
import RuleModal from '@/components/_tb_modal/RuleModal/RuleModal'
import DoHelpModal from '@/components/_tb_modal/DoHelpModal/DoHelpModal'
import TasksModal from '@/components/_tb_modal/TasksModal/TasksModal'
import CountDown from '@/components/_tb_comps/CountDown/CountDown'
import styles from './index.module.less'
import tbcc from 'tbcc-sdk-ts'
import { useEffect } from 'react'
const { navigateTo, openDetail, showSharePanel } = tbcc.tb
const { getImgShareUrl, checkIsMember, validateActivityStatus } = tbcc.utils

import {useAudio} from '@/hooks/useAudio'
import {CLOUD_OBJ, BGMUSIC_URL} from '@/const'

import ScrollXView from '@/components/_tb_comps/ScrollXView/ScrollXView'

import SwiperView from '@/components/_tb_comps/SwiperView/SwiperView'

import RotateWheel from '@/components/_tb_comps/RotateWheel/RotateWheel'

const INDEX_CONFIG = {
  bg: '', // 背景 cloud://C4015B7CEC23CF013A78247E2852524F//火箭待机小球抖动.json
  ruleButton: '', // 规则按钮
  myPrizeButton: '', // 我的奖品按钮
  shareButton: '', // 分享按钮
  taskButton: '' // 任务按钮
}

const rotateConfig = {
  bg: 'https://yun.duiba.com.cn/spark/assets/8b6e920ffd09fab8f9ac2de09f9154879f4d0607.png',
  ratio: 0.65,
  radius: 300,
  circles: 4,
  divideNum: 8,
  duration: 5000,
  timeFunction:'ease-in-out',
  nodeInfo:{
      width:100,
      height:100
  },
  imgInfo:{width:80,height:80},
  showWay:'negative',//positive/negative
  isShowPrizeName:true,
  prizeNameWidthRatio:1.2
}

const SCROLLXVIEW_CONFIG = {
  prizeList: [], 
  containerWidth : 300, 
  containerHeight : 300,
  imgWidth:200,
  imgHeight:200,
  isShowPrizeName:true,
  prizeInCenterNum:2,
  marginRight:26,
  backgroundColor:'#E7E7EF'
}

function Index() {
  const app = getApp()
  const { activityInfo, setActivityInfoAndStatus } = useActivityInfoModel()
  const { loginInfo } = useLoginInfoModel()

  const [ memberVisible, setMemberVisible ] = useState(false)
  const [ doHelpModalVisible, setDoHelpModalVisible ] = useState(false)
  const [ ruleModalVisible, setRuleModalVisible ] = useState(false)
  const [ tasksModalVisible, setTasksModalVisible ] = useState(false)
  const [updateFlag, setUpdateFlag] = useState(1)
  // 分享图
  const SHARE_IMG = useRef('')
  // 助力弹窗类型
  const [helpType,setHelpType] = useState(HELP_MODAL_TYPE.HELP)
  // 助力弹窗标识
  const showHelp = useRef(false)

  /* 背景音乐 */
  const {playAudio,musicUrl,setOpenStatus,openStatus} = useAudio(CLOUD_OBJ['1'])

  const playCurrentAudio = () => {
    // setOpenStatus(!openStatus)
    playAudio(()=>{
      onHandleIndex('prize')
    })
  }

  const fetchActivityInfo = async() => {
    const { success, data } = await API.getActivityBaseInfoById()
    if(success) {
      const { startTime, endTime, rule } = data
      setActivityInfoAndStatus({
        startTime, endTime,  rule
      })
    }
  }
  // 获取用户信息
  const fetchUserInfo = async () => {
    const { success, data } = await API.getUserInfo()
    success && setUserInfo(data)
  }
  useEffect(() =>{
    // fetchActivityInfo()
    // getImgShareUrl('cloud://CEFE74AE67921906B5AF842150646D35/share.png').then(url => {
    //   SHARE_IMG.current = url
    // })
  },[])
  // 授权登录完成
  useLogin(async (info) => {
    handleVisibleModal(info)
    // setUpdateFlag(1)
  })
  // 查看是否有助力信息
  const getShareInfo = async () => {
    const { success, data } = await API.getShareInfo()
    if(success && data && data?.inviteCount) {
      setHelpInfo(data)
      setDoHelpModalVisible(true)
      setHelpType(HELP_MODAL_TYPE.REWARDS)
    }
  }
  // 分享链接进入活动
  useLoginFromShare((inviteId) => {
    console.log('inviteId :>> ', inviteId)
    app.inviteId = inviteId
  })

  useShareAppMessage(() => {
    return {
      ...SHARE_CONFIG,
      imageUrl: SHARE_IMG.current,
      path: `pages/index/index?inviteId=${loginInfo.openId}`
    }
  })
  // 助力弹窗 -> 其他弹窗
  const handleVisibleModal = async (info) => {
    const isVip = await checkIsMember()
    // 是否为助力弹窗
    if(app.inviteId && !showHelp.current) {
      setDoHelpModalVisible(true)
      setHelpType(isVip? HELP_MODAL_TYPE.FAIL: HELP_MODAL_TYPE.HELP)
      showHelp.current = true
      return;
    }
    // 其他弹窗
  }
  const onClose = () => {
    setMemberVisible(false)
  }
  const onAuthSuccess = () => {
    setMemberVisible(false)
  }
  const onAuthFail = () => {
    setMemberVisible(false)
  }

  const onHandleClose = () => { 
    setDoHelpModalVisible(false)
    if(loginInfo.newUser) {
      handleVisibleModal(loginInfo)
    }
    if(helpType === HELP_MODAL_TYPE.REWARDS) {
      setUpdateFlag(HELP_MODAL_TYPE.REWARDS)
      fetchUserInfo()
    }
  }

  const onHandleIndex = (type,updateActInfo) => {
    const Fn = {
      'updateUserInfo': () => {
        fetchUserInfo()
        updateActInfo && fetchActivityInfo()
      },
      'rule': () => setRuleModalVisible(true),
      'prize': () => {navigateTo('/pages/packagePrize/myPrize/myPrize')},
      'game': () => navigateTo('/pages/packageGame/game/game')
    }
    Fn[type]()
  }

  return (
    <View className={styles.container} style={{ backgroundImage: `url(${INDEX_CONFIG.bg})`}}>
      <View className={styles.rule} style={{ backgroundImage: `url(${INDEX_CONFIG.ruleButton})` }} onClick={() => setRuleModalVisible(true)}>活动规则</View>
      <View className={styles.my_prize} style={{ backgroundImage: `url(${INDEX_CONFIG.myPrizeButton})` }} onClick={() => onHandleIndex('prize')}>我的奖品</View>
      <View className={styles.tasks} style={{ backgroundImage: `url(${INDEX_CONFIG.taskButton})` }} onClick={() => setTasksModalVisible(true)}>任务</View>
      <View className={styles.games} style={{ backgroundImage: `url(${INDEX_CONFIG.taskButton})` }} onClick={() =>onHandleIndex('game') }>游戏</View>

      <View className={styles.bemember} onTap={() => setMemberVisible(true)}>入会</View>

      {/* 奖品查看左右滑动 */}
      {/* <ScrollXView {...SCROLLXVIEW_CONFIG} prizeList={prizeList} /> */}

      {/* swiper左右滑动 */}
      {/* <SwiperView  swiperList={prizeList} /> */}


      {/* 大转盘 */}
      {/* <View className={styles['rotate']} 
        style={{
          width:`${600/100}rem`,
          height:`${600/100}rem`,
          margin:`${100/100}rem auto`,
          display:'flex',
          justifyContent:'center',
          alignItems:'center'
        }} >
        <RotateWheel {...rotateConfig} callback={()=>{}} />
      </View> */}

      <View className='view' onTap={playCurrentAudio}>play audio</View>

      {
        tasksModalVisible &&
          <TasksModal
            onUpdate={() => {}}
            onClose={() => setTasksModalVisible(false)}
          />
      }
      {
        ruleModalVisible &&
          <RuleModal
            closePostion='bottom'
            bg=''
            width='500'
            height='300'
            rule={activityInfo.rule}
            onClose={() => setRuleModalVisible(false)}
          />
      }
      {
        doHelpModalVisible &&
          <DoHelpModal
            closePostion='bottom'
            bg=''
            width='500'
            height='500'
            top='45%'
            newVip
            onClose={() => setDoHelpModalVisible(false)}
          />
      }
      {<member-modal expend={memberVisible} sellerId={98563612} onClose={onClose} onAuthFail={onAuthFail} onAuthSuccess={onAuthSuccess} />}
    </View>
  )
}

export default Index
