import { useCallback } from 'react'
import { checkIsMember } from 'tbcc-sdk-ts/lib/utils'
import API from '@/api'
import {receiveEnamePrize, receiveMemberEname, receiveObjectPrize } from 'tbcc-sdk-ts/lib/request/capiFn'
import { PRIZE_TYPE, BENEFIT_TYPE } from '@/config/myPrize.config'

const useReceive = (config) => {
  const receivePrize = async(item, callbackObj={vipCallback:()=>{},updateCallback:()=>{},closeCallback:()=>{}}) => {
    const app = getApp();
    const { activityId } = app
    const { type, id, ename = '', benefitType } = item

    const successMsg = '领取成功'
    const errorMsg = '请求失败'

    if(type === PRIZE_TYPE.CREDITS || (type === PRIZE_TYPE.ENAME && benefitType === BENEFIT_TYPE.MEMBER)) {
        const isVip = await checkIsMember()
        if(!isVip) {
          commonToast('需加入会员才能领取成功哦', 2000, ()=>{callbackObj.vipCallback && callbackObj.vipCallback()})
          return;
        }
    }
    const receiveFn = {
        // 'update': async () => fetchMyPriceList(),
        [PRIZE_TYPE.ENAME]: async () => {
          if(benefitType === BENEFIT_TYPE.MEMBER) {
           await receiveMemberEname(API.receiveMemberEname,{params: { sellerId: config.sellerId, ename, id }, successMsg, errorMsg })
          }else {
            await receiveEnamePrize(API.receiveEnamePrize, {params: { activityId, id }, successMsg, errorMsg })
          }
        },
        [PRIZE_TYPE.OBJECT]: async () => {
          await receiveObjectPrize(API.receiveObjectPrize, {params: { activityId, id }, successMsg, errorMsg })
        },
        [PRIZE_TYPE.CREDITS]: async () => {
          await receiveEnamePrize(API.receiveEnamePrize, {params: { activityId, id }, successMsg, errorMsg })
        }
    }
    await receiveFn[type]()
    //  更新奖品列表
    callbackObj.updateCallback && callbackObj.updateCallback();

    callbackObj.closeCallback && callbackObj.closeCallback();
  }

  return {
    receivePrize
  }
}

export default useReceive
