import { SHARE_CONFIG, REDIRECT_URL } from '../../constants';
import API from '../../api';

const app = getApp();
const { tbcc } = app;
const { commonToast, getAuthUserInfo, navigateToOutside } = tbcc.tb;

Page({
  data: {
    title: '',
    content: '',
    rule: '',
    commonModalData: {
      content: '',
      btnText: ''
    },
    commonModalConfirm: null,
    commonModalVisible: false,
    ruleModalVisible: false
  },
  onLoad(query) {
    // 页面加载
    this.getAuth();
    console.info(`Page onLoad with query: ${JSON.stringify(query)}`);
  },
  init() {
    this.getActivityBaseInfoById();
  },
  onReady() {
    // 页面加载完成
  },
  onShow() {
    // 页面显示
  },
  onHide() {
    // 页面隐藏
  },
  onUnload() {
    // 页面被关闭
  },
  onTitleClick() {
    // 标题被点击
  },
  onPullDownRefresh() {
    // 页面被下拉
  },
  onReachBottom() {
    // 页面被拉到底部
  },
  /**
   * 获取用户授权信息
   */
  async getAuth() {
    const userInfo = await getAuthUserInfo().catch(err => {
      console.log('未授权成功', err);
    });
    if (userInfo) {
      console.log('userInfo', userInfo);
      const { nickName, avatar } = userInfo;
      app.nickName = nickName;
      app.avatar = avatar;
      this.login();
    }
  },
  /**
   * 获取主接口
   */
  async getActivityBaseInfoById() {
    const { success, data } = await API.getActivityBaseInfoById().catch(res => {
      commonToast(res && res.message);
    }) || {};

    if (success && data) {
      const { title, content, rule } = data;
      this.setData({ title, content, rule });
    }
  },
  /**
   * 登录接口
   */
  async login() {
    const { nickName, avatar } = app;
    const { success } = await API.login({ userNick: nickName, avatar }).catch(res => {
      commonToast(res && res.message);
    }) || {};

    if (success) {
      this.init();
    }
  },
  /**
   * 显示规则弹层
   */
  showRuleModal() {
    this.setData({
      ruleModalVisible: true
    });
  },
  /**
   * 通用弹出确认按钮回调
   */
  confirmCommonModal() {
    const { commonModalConfirm } = this.data;
    commonModalConfirm && commonModalConfirm();
  },
  /**
   * 执行开始
   */
  doStart() {
    this.showCommonModal({
      content: '活动还未开始\n请稍后',
      btnText: '我知道了',
      commonModalVisible: true,
      confirmCallback: () => {
        this.closeCommonModal();
      }
    });
  },
  /**
   * 显示通用弹层
   * @param {object} options content: 通用弹层内容 btnText:按钮文案 confirmCallback: 按钮确认回调
   */
  showCommonModal({ content, btnText, confirmCallback }) {
    this.setData({
      commonModalConfirm: confirmCallback || null,
      commonModalVisible: true,
      commonModalData: { content, btnText }
    });
  },
  /**
   * 跳转到天猫页面
   */
  goTmallPage() {
    navigateToOutside(REDIRECT_URL['tmall']);
  },
  /**
   * 关闭通用弹层
   */
  closeCommonModal() {
    this.setData({
      commonModalVisible: false
    });
  },
  /**
   * 关闭活动规则弹层
   */
  closeRuleModal() {
    this.setData({
      ruleModalVisible: false
    });
  },
  onShareAppMessage() {
    // 返回自定义分享信息
    return SHARE_CONFIG;
  },
});
