import React,{useState, useEffect} from 'react'
import {View,Image,Text} from '@tarojs/components'
import styles from './LoadingBar.module.less'

export const LOAD_TYPE = {
    'TASK':"TASK",
    'NORMAL':"NORMAL"
}

const LoadingBar = (props) => {
    const {
        bg='https://yun.duiba.com.cn/spark/assets/5a725b9e4ebf436a0a92c6317a5a4e47d87c8c1f.png',
        bgTop='https://yun.duiba.com.cn/spark/assets/ccc405e28a5140d3aff9dff27b97fa5fb6bd7ff5.png',
        type='',
        total=0,
        current=0
    } = props;
    
    const [percent,setPercent] = useState(0);

    useEffect(()=>{
        showCurrentLoading();
    },[])

    /**
     * @description 显示当前进度(进度条上没有其他内容)
     */
    const showCurrentLoading = () => {
        if(type == LOAD_TYPE.NORMAL){
            let cur = current >= total ? toal : current;
            setPercent((cur / total * 100).toFixed(1))
        }
    }


    return(
        <View className={styles['load_container']} >
            <View className={styles['load_content']} >
                <View className={styles['load_bg']} style={{backgroundImage:`url(${bg})`}} ></View>
                <View 
                    className={`${styles['load_top']} ${type == LOAD_TYPE.TASK && 'loadAni'}`} 
                    style={{
                        backgroundImage:`url(${bgTop})`,
                        clipPath:`${type==LOAD_TYPE.NORMAL && `inset(0% 0% 0% ${percent}%)`}`
                    }} 
                ></View>
            </View>
        </View>
    )
}
export default LoadingBar