"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.confirmCustomOrder = exports.hideSkuModal = exports.showSkuModal = exports.openMessage = exports.taobaoReportClick = exports.removeStorage = exports.setStorage = exports.getStorage = exports.showSharePanel = exports.setClipboard = exports.getImageInfo = exports.createAudio = exports.openDetail = exports.checkGoodsCollectedStatus = exports.collectGoods = exports.getServerTime = exports.redirectTo = exports.navigateBack = exports.navigateTo = exports.navigateToOutside = exports.checkShopFavoredStatus = exports.favorShop = exports.getSystemInfo = exports.commonConfirm = exports.simpleAlert = exports.commonToast = void 0;
var helpers_1 = require("../helpers");
/**
 * 通用toast
 * @param {string} content toast内容
 * @param {number} duration 显示时长
 * @param {function} successCb 成功回调
 */
exports.commonToast = function (content, duration, successCb) {
    helpers_1.promisifyApiSimple('showToast', {
        content: content || '换个姿势再试一次~',
        duration: duration || 3000,
        success: successCb
    });
};
/**
 * 简易alert
 * @param {string} content toast内容
 */
exports.simpleAlert = function (content) {
    helpers_1.promisifyApiSimple('alert', {
        content: content
    });
};
/**
 * 通用确认弹窗
 * @param {string} title 标题
 * @param {string} content 内容
 * @param {function} successCb 成功回调
 */
exports.commonConfirm = function (title, content, successCb) {
    if (title === void 0) { title = '提示'; }
    return __awaiter(void 0, void 0, void 0, function () {
        return __generator(this, function (_a) {
            helpers_1.promisifyApiSimple('confirm', {
                title: title,
                content: content,
                confirmButtonText: '确定',
                cancelButtonText: '取消',
                success: function (result) {
                    var confirm = result.confirm;
                    if (confirm) {
                        successCb && successCb();
                    }
                }
            });
            return [2 /*return*/];
        });
    });
};
/**
 * 获取系统信息
 */
exports.getSystemInfo = function () { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, helpers_1.promisifyApi('getSystemInfo', {})];
            case 1: return [2 /*return*/, _a.sent()];
        }
    });
}); };
/**
 * 执行关注店铺
 * @param {number} sellerId 店铺归属的卖家Id
 * @returns {boolean} 关注状态
 */
exports.favorShop = function (sellerId) { return __awaiter(void 0, void 0, void 0, function () {
    var result;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (!sellerId) {
                    return [2 /*return*/, false];
                }
                return [4 /*yield*/, helpers_1.promisifyApiToTb('favorShop', { id: +sellerId })];
            case 1:
                result = _a.sent();
                if ((result === null || result === void 0 ? void 0 : result.error) === 11)
                    return [2 /*return*/, false];
                return [2 /*return*/, result];
        }
    });
}); };
/**
 * 判断是否关注店铺
 * @param {number} sellerId 店铺归属的卖家Id
 * @returns {boolean} 关注状态
 */
exports.checkShopFavoredStatus = function (sellerId) { return __awaiter(void 0, void 0, void 0, function () {
    var result;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (!sellerId) {
                    return [2 /*return*/, false];
                }
                return [4 /*yield*/, helpers_1.promisifyApiToTb('checkShopFavoredStatus', { id: +sellerId })];
            case 1:
                result = _a.sent();
                if (result === null || result === void 0 ? void 0 : result.isFavor)
                    return [2 /*return*/, result.isFavor];
                return [2 /*return*/, result];
        }
    });
}); };
/**
 * 跳转到外部链接
 * @param {string} url 跳转链接
 */
exports.navigateToOutside = function (url) {
    if (!url) {
        console.error('navigateToOutside: 请传入url');
        return false;
    }
    helpers_1.promisifyApiSimple('call', {
        url: url
    }, 'navigateToOutside');
};
/**
 * 跳转到内部链接（新开窗口）
 * @param {string} url 跳转链接
 */
exports.navigateTo = function (url) {
    if (!url) {
        console.error('navigateTo: 请传入url');
        return false;
    }
    helpers_1.promisifyApiSimple('navigateTo', {
        url: url
    });
};
/**
 * 返回页面
 * @param {number} delta
 */
exports.navigateBack = function (delta) {
    helpers_1.promisifyApiSimple('navigateBack', {
        delta: delta
    });
};
/**
 * 跳转到内部链接（不新开窗口）
 * @param {string} url
 */
exports.redirectTo = function (url) {
    if (!url) {
        console.error('redirectTo: 请传入url');
        return false;
    }
    helpers_1.promisifyApiSimple('redirectTo', {
        url: url
    });
};
/**
 * 获取服务器时间
 * @returns {number} 服务器时间戳
 */
exports.getServerTime = function () { return __awaiter(void 0, void 0, void 0, function () {
    var result;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, helpers_1.promisifyApi('getServerTime', {})];
            case 1:
                result = _a.sent();
                if (result === null || result === void 0 ? void 0 : result.time)
                    return [2 /*return*/, result.time];
                return [2 /*return*/, result];
        }
    });
}); };
/**
 * 收藏商品
 * @param {number} 商品id
 * @returns {object} 收藏结果
 */
exports.collectGoods = function (id) { return __awaiter(void 0, void 0, void 0, function () {
    var result;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (!id) {
                    console.error('collectGoods: 请传入商品id');
                    return [2 /*return*/, false];
                }
                return [4 /*yield*/, helpers_1.promisifyApiToTb('collectGoods', { id: +id })];
            case 1:
                result = _a.sent();
                if ((result === null || result === void 0 ? void 0 : result.error) === 11)
                    return [2 /*return*/, false];
                return [2 /*return*/, result];
        }
    });
}); };
/**
 * 查询商品收藏状态
 * @param {number} 商品id
 * @returns {boolean} 商品收场状态
 */
exports.checkGoodsCollectedStatus = function (id) { return __awaiter(void 0, void 0, void 0, function () {
    var result;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (!id) {
                    console.error('checkGoodsCollectedStatus: 请传入商品id');
                    return [2 /*return*/, false];
                }
                return [4 /*yield*/, helpers_1.promisifyApiToTb('checkGoodsCollectedStatus', { id: +id })];
            case 1:
                result = _a.sent();
                if (result === null || result === void 0 ? void 0 : result.isCollect)
                    return [2 /*return*/, result.isCollect];
                return [2 /*return*/, result];
        }
    });
}); };
/**
 * 跳转到淘宝商品页
 * @param {string} itemId 商品ID
 */
exports.openDetail = function (itemId) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (!itemId) {
                    console.error('openDetail: 请传入商品id');
                    return [2 /*return*/, false];
                }
                return [4 /*yield*/, helpers_1.promisifyApiToTb('openDetail', { itemId: String(itemId) })];
            case 1: return [2 /*return*/, _a.sent()];
        }
    });
}); };
/**
 * 创建音频实例
 * @param {object} opts 配置对象 例 { src: '音频链接', autoplay: false }
 */
exports.createAudio = function (opts) {
    var audioInstance = new helpers_1.AudioModel(opts);
    return audioInstance;
};
/**
 * 获取图片信息
 * @param {string} src 图片地址
 */
exports.getImageInfo = function (src) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, helpers_1.promisifyApi('getImageInfo', { src: src })];
            case 1: return [2 /*return*/, _a.sent()];
        }
    });
}); };
/**
 * 剪切板
 * @param {text: string}
 */
exports.setClipboard = function (text) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, helpers_1.promisifyApi('setClipboard', { text: text })];
            case 1: return [2 /*return*/, _a.sent()];
        }
    });
}); };
/**
 * 调起分享面板
 */
exports.showSharePanel = function () { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        helpers_1.promisifyApiSimple('showSharePanel', {});
        return [2 /*return*/];
    });
}); };
/**
 * 获取缓存数据
 * @param key
 */
exports.getStorage = function (key) { return __awaiter(void 0, void 0, void 0, function () {
    var result;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, helpers_1.promisifyApi('getStorage', { key: key })];
            case 1:
                result = _a.sent();
                if (result === null || result === void 0 ? void 0 : result.data)
                    return [2 /*return*/, result.data];
                return [2 /*return*/, result];
        }
    });
}); };
/**
 * 设置缓存数据
 * @param key
 * @param value
 */
exports.setStorage = function (key, value) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, helpers_1.promisifyApi('setStorage', { key: key, data: value })];
            case 1: return [2 /*return*/, _a.sent()];
        }
    });
}); };
/**
 * 清除缓存数据
 * @param key
 */
exports.removeStorage = function (key) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, helpers_1.promisifyApi('removeStorage', { key: key })];
            case 1: return [2 /*return*/, _a.sent()];
        }
    });
}); };
/**
 * 自定义分析数据的上报接口
 * @param eventType
 * @param logkey
 */
exports.taobaoReportClick = function (eventType, logkey) {
    // @ts-ignore
    my.reportAnalytics(eventType, {
        // 标志某一类事件，方便数据分析进行分组
        'logkey': logkey
    });
};
/**
 * 打开BC客服聊天
 * @param sellerNick
 * @param itemId
 */
exports.openMessage = function (sellerNick, itemId) { return __awaiter(void 0, void 0, void 0, function () {
    var result;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, helpers_1.promisifyApiToTb('openMessage', { sellerNick: sellerNick, forceH5: false, params: { itemId: itemId } })];
            case 1:
                result = _a.sent();
                return [2 /*return*/, result];
        }
    });
}); };
/**
 * 显示指定商品 SKU 选择器
 * @param itemId
 */
exports.showSkuModal = function (itemId) { return __awaiter(void 0, void 0, void 0, function () {
    var result;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, helpers_1.promisifyApiToTb('showSku', { itemId: itemId })];
            case 1:
                result = _a.sent();
                return [2 /*return*/, result];
        }
    });
}); };
/**
 * 隐藏正在展示的商品 SKU 选择器
 */
exports.hideSkuModal = function () { return __awaiter(void 0, void 0, void 0, function () {
    var result;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, helpers_1.promisifyApiToTb('hideSku', {})];
            case 1:
                result = _a.sent();
                return [2 /*return*/, result];
        }
    });
}); };
/**
 * 跳转订单页
 * @param itemId
 * @param skuId
 * @param quantity
 */
exports.confirmCustomOrder = function (itemId, skuId, quantity) { return __awaiter(void 0, void 0, void 0, function () {
    var result;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, helpers_1.promisifyApiToTb('confirmCustomOrder', {
                    data: {
                        itemId: itemId,
                        skuId: skuId || -1,
                        quantity: quantity || 1,
                        customization: {}
                    }
                })];
            case 1:
                result = _a.sent();
                return [2 /*return*/, result];
        }
    });
}); };
//# sourceMappingURL=tb.js.map