import { SHARE_CONFIG, REDIRECT_URL, SHARE_IMG_FILE_ID, SELLER_ID } from '../../constants';
import API from '../../api';

const app = getApp();
const { tbccTs } = app;
const { commonToast, getAuthUserInfo, navigateToOutside, checkShopFavoredStatus, navigateTo } = tbccTs.tb;
const { getImgShareUrl, checkMember, validateActivityStatus } = tbccTs.utils

Page({
  shareImgUrl: null,
  openId: null,
  isDoHelpFlag: false,
  data: {
    startTime: '',
    endTime: '',
    rule: '',
    ruleModalVisible: false,// 规则弹窗
    taskModalVisible: false,// 任务弹窗
    memberShopVisible: false,// 入会弹窗
    prizeModalVisible: false,// 奖品弹窗
    taskFlag: 1
  },
  onLoad(query) {
    // 页面加载
    this.getAuth();
    app.inviteId = query.inviteId
    console.info(`Page onLoad with query: ${JSON.stringify(query)}`);
  },
  init() {
    this.getActivityBaseInfoById();
    this.getImgShareUrl()
  },
  onReady() {
    // 页面加载完成
  },
  onShow() {
    // 页面显示
    if(app.isFlashTask) { // 任务数据更新
      this.setData({ taskFlag: Math.floor(Math.random() * 1000)})
    }
  },
  onHide() {
    // 页面隐藏
  },
  onUnload() {
    // 页面被关闭
  },
  onTitleClick() {
    // 标题被点击
  },
  onPullDownRefresh() {
    // 页面被下拉
  },
  onReachBottom() {
    // 页面被拉到底部
  },
  /**
   * 获取用户授权信息
   */
  async getAuth() {
    const userInfo = await getAuthUserInfo().catch(err => {
      console.log('未授权成功', err);
    });
    if (userInfo) {
      console.log('userInfo', userInfo);
      const { nickName, avatar } = userInfo;
      app.nickName = nickName;
      app.avatar = avatar;
      this.login();
    }
  },
  /**
   * 获取主接口
   */
  async getActivityBaseInfoById() {
    const { isOnlineActivity } = app
    const { success, data } = await API.getActivityBaseInfoById().catch(res => {
      commonToast(res && res.message);
    }) || {};

    if (success && data) {
      const { startTime, endTime, rule } = data;
      this.setData({ startTime, endTime, rule });
      // 性能检测使用
      if(Date.now() < startTime && !isOnlineActivity) {
        navigateTo(`/pages/endPage/endPage`)
      }
    }
  },
  /**
   * 登录接口
   */
  async login() {
    const { nickName, avatar, inviteId = undefined } = app;
    const isFollow = await checkShopFavoredStatus(SELLER_ID).catch(err => {
      console.log('查询关注店铺状态失败', err);
    })
    const { success, data } = await API.login({
      userNick: nickName, avatar, isFollow: !!isFollow, inviteId
    }).catch(res => {
      commonToast(res && res.message);
    }) || {};
    console.warn(success,data)
    if (success) {
      const { openId } = data || {}
      this.openId = openId
      this.init();
    }
  },
  /**
   * 跳转到天猫页面
   */
  goTmallPage() {
    navigateToOutside(REDIRECT_URL['tmall']);
  },
  // 打开弹窗
  async openModalHandle(e) {
    const { startTime, endTime } = this.data
    const key = typeof e === 'string' ? e : e.target.dataset.dataName
    if(key !== 'ruleModalVisible') {
      const canPass = await validateActivityStatus(startTime, endTime, true)
      if(!canPass) return;
    }
    // 可根据key值处理相应逻辑
    switch(key) {
      default: 
        this.setData({ [key]: true })
        break;
    }
  },
  // 关闭弹窗
  closeModalHandle(key) {
    // 可根据key值处理相应逻辑
    switch(key) {
      default: 
        this.setData({ [key]: false })
        break;
    }
  },
  onShareAppMessage(from) {
    // 返回自定义分享信息
    return {
      ...SHARE_CONFIG,
      imageUrl: this.shareImgUrl,
      path: `/pages/index/index?inviteId=${this.openId}`
    }
  },
  // 任务模块-助力（逻辑：仅活动内入会才可助力成功），其他自行替换
  async doHelpHandle() {
    const { activityId, inviteId } = app

    this.setData({ helpModalVisible: false })
    // 判断是否邀请链接进来
    if(!inviteId) return;

    // 助力拦截 若已经助力不在调用
    if(this.isDoHelpFlag) return;

    // 判断是否是会员
    // const isVip = await API.fn.getVipInfo({ activityId })
    const isMember = await checkMember(SELLER_ID)
    if(isMember) {
      commonToast('只有新会员才可助力成功哦')
      return;
    }
    this.setData({ memberShopVisible: true })
  },
  async doHelp() {
    const { activityId, inviteId } = app
    let { success, data } = await API.doHelp({ activityId, inviteId }).catch(res => {
      commonToast(res.message)
    }) || {}

    if(success) {
      commonToast('助力成功')
      this.isDoHelpFlag = true
    }
  },
  // 关闭入会组件
  closeCommonModal() {
    this.setData({ memberShopVisible: false })
  },
  // 入会成功
  onSuccess() {
    this.setData({ memberShopVisible: false })
    this.doHelp()
  },
  // 获取分享图地址
  async getImgShareUrl() {
    this.shareImgUrl = await getImgShareUrl(SHARE_IMG_FILE_ID)
  },
});
