/**
   * 任务类型（taskType）:collectGoods、 orderGoods 、 browseGoods 、exchangeCredits
   * task: {
   *  itemId: //商品ID
   *  taskType: //任务类型
   *  type: //头部样式（02——banner，01——标题）
   *  image: {//图片
   *    bg: //集合页背景
   *    banner: //头部banner
   *    title: //头部title
   *    collect: //商品以收藏
   *    no_collect: //商品未收藏
   *  }
   *  color: //商品名称：文字颜色
   * }
 */
import API from '../../api';
const app = getApp();
const { tbccTs } = app;
const { commonToast } = tbccTs.tb;
const taskConfig = {
  taskType: 'collectGoods',
  type: '01',
  image: {
    bg: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_bg@2x.png',
    banner: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_banner@2x.png',
    title: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_title@2x.png',
    collect: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_collection@2x.png',
    no_collect: '//yun.duiba.com.cn/taobaomini/clientCTest/collection_no_collect@2x.png',
    img: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_img@2x.png',
  },
  color: '#181818'
}

Page({
  data: {
    query: {},
    task: taskConfig,
    goodsList: []
  },
  onLoad(query) {
    this.query = query || {}
    this.initPage()
  },
  onShow() {
  },
  async initPage() {
    const { activityId } = app
    const { itemIds } = this.query

    const { success, data } = await API.getCollectGoodsList({ activityId, itemIds }).catch(res => {
      res && commonToast(res)
    }) || {}
    if(success) {
      this.setData({ goodsList: data.list || [] })
    }
  },
  //任务完成 616444374083
  async onCompleteTask(taskType,itemId) {
    console.log(taskType,itemId)

    const { activityId } = app
    let { success, data } = await API.doCollectGoodsTask({ activityId, itemId }).catch(res => {
      res && commonToast(res.message)
    }) || {}
    if(success) {
      commonToast('收藏成功')
      this.initPage()
    }
  }
});
