/**
 * 通用toast
 * @param {string} content toast内容
 * @param {number} duration 显示时长
 */
export const commonToast = (content, duration = 3000) => {
    my.showToast({
      content: content || '换个姿势再试一次~',
      duration
    });
  };
  
  /**
   * 获取授权用户信息
   * @returns {object} 用户登录信息
   */
  export const getAuthUserInfo = () => {
    return new Promise((resolve, reject) => {
      my.authorize({
        scopes: 'scope.userInfo',
        success: res => {
          my.getAuthUserInfo({
            success: userInfo => { resolve(userInfo); }
          });
        },
        fail: err => {
          reject(err);
        }
      });
    });
  };
  
  /**
   * 获取系统信息
   * @returns {object} 小程序系统信息
   */
  export const getSystemInfo = () => {
    return new Promise((resolve, reject) => {
      my.getSystemInfo({
        success: res => { resolve(res); },
        fail: err => { reject(err); }
      });
    });
  };
  
  /**
   * 执行关注店铺
   * @param {number} sellerId 店铺归属的卖家Id
   * @returns {boolean} 关注状态
   */
  export const favorShop = sellerId => {
    return new Promise((resolve, reject) => {
      my.tb.favorShop({
        id: sellerId,
        success: res => {
           console.log(res, '关注店铺');
          resolve(res);
        },
        fail: err => {
          console.log(err, '关注店铺失败');
          // error code 11 为用户取消操作不认作失败场景
          // if (err.error !== 11) {
            reject(err);
          // }
        }
      });
    })
  };
  
  /**
   * 判断是否关注店铺
   * @param {number} sellerId 店铺归属的卖家Id
   * @returns {boolean} 关注状态
   */
  export const checkShopFavoredStatus = sellerId => {
    return new Promise((resolve, reject) => {
      my.tb.checkShopFavoredStatus({
        id: sellerId,
        success: res => {
          resolve(res.isFavor);
        },
        fail: err => {
          reject(err);
        }
      });
    });
  };
  
  /**
   * 跳转到外部链接
   * @param {string} url 跳转链接
   */
  export const navigateToOutside = url => my.call("navigateToOutside", { url });
  
  /**
   * 跳转到内部链接（新开窗口）
   * @param {string} url 跳转链接
   */
  export const navigateTo = url => my.navigateTo({ url });
  
  /**
   * 跳转到内部链接（不新开窗口）
   * @param {string} url 跳转链接
   */
  export const redirectTo = url => my.redirectTo({ url });
  
  /**
   * 获取服务器时间
   * @returns {number} 服务器时间戳
   */
  export const getServerTime = () => {
    return new Promise((resolve, reject) => {
      my.getServerTime({
        success: (res) => {
          resolve(res.time);
        },
        fail: err => {
          reject(err);
        }
      });
    });
  };
  
  /**
   * 收藏商品
   * @param {number} 商品id
   * @returns {object} 收藏结果
   */
  export const collectGoods = id => {
    return new Promise((resolve, reject) => {
      my.tb.collectGoods({
        id,
        success: res => {
          resolve(res);
        },
        fail: err => {
          if (err.errorMessage === '该商品已收藏') {
            // 已收藏没有给到errorCode，只能通过message判断
            // 返回收藏成功，并且给到标记代表是已收藏的
            resolve({ success: true, hasCollected: true, errorMessage: err.errorMessage });
          } else if (err.error !== 11) {
            // error code 11 为用户取消操作不认作失败场景
            reject(err);
          }
        }
      });
    });
  };
  
  /**
   * 查询商品收藏状态
   * @param {number} 商品id
   * @returns {boolean} 商品收场状态
   */
  export const checkGoodsCollectedStatus = id => {
    return new Promise((resolve) => {
      my.tb.checkGoodsCollectedStatus({
        id,
        success: res => {
          resolve(res.isCollect);
        }
      });
    });
  };
  
  /**
   * 时间格式化
   * @param date    接收可以被new Date()方法转换的内容
   * @param format  字符串，需要的格式例如：'yyyy-MM-dd hh:mm:ss'
   * @returns {String}
   */
  export const dateFormatter = (date, format = 'yyyy-MM-dd') => {
    if (!date) return '-';
  
    date = new Date(typeof date === 'string' && isNaN(date) ? date.replace(/-/g, '/') : date);
    let o = {
      'M+': date.getMonth() + 1,
      'd+': date.getDate(),
      'h+': date.getHours(),
      'm+': date.getMinutes(),
      's+': date.getSeconds(),
      'q+': Math.floor((date.getMonth() + 3) / 3),
      'S': date.getMilliseconds()
    };
    if (/(y+)/.test(format)) {
      format = format.replace(RegExp.$1, (date.getFullYear() + '').substr(4 - RegExp.$1.length));
    }
    for (let k in o) {
      if (new RegExp('(' + k + ')').test(format)) {
        format = format.replace(RegExp.$1, (RegExp.$1.length === 1) ? (o[k]) : (('00' + o[k]).substr(('' + o[k]).length)));
      }
    }
    return format;
  };
  
  
  /**
   * 创建音频类
   */
  class AudioModel {
    constructor(opts = {}) {
      const { src } = opts;
      if (!src) {
        console.error('请输入音频链接');
        return false;
      }
      try {
        const innerAudioContext = my.createInnerAudioContext();
        Object.keys(opts).forEach(item => {
          innerAudioContext[item] = opts[item];
        });
        return innerAudioContext;
      } catch(e) {
        console.error('当前版本不支持音频');
      }
    }
  };
  /**
   * 创建音频实例
   * @param {object} opts 配置对象 例 { src: '音频链接', autoplay: false }
   */
  export const createAudio = opts => {
    const audioInstance = new AudioModel(opts)
    return audioInstance;
  };
  
  //暂时只有一个音乐，临时处理
  let bgMusic
  export const playBgMusic = (isOn,src) => {//待测试
    if (isOn) {
      if (!bgMusic) {
        bgMusic = createAudio({
          src: src||"https://yun.duiba.com.cn/db_games/activity/babycare_xiaoxiao/bgm_babycare.mp3",
          autoplay: true,
          loop: true//暂时无效？
        });
        //监听结束，因为loop无效
        bgMusic.onEnded(() => {
          // bgMusic.seek(0);
           bgMusic.play();
        })
        console.log(src)
      } else {
        bgMusic.play();
      }
    } else {
      if (bgMusic) {
        // bgMusic.pause();
        bgMusic.stop();
        // bgMusic.seek(0);
      }
    }
  }
  /**
   * 版本比较
   * @param {string} cur 当前版本
   * @param {string} compare 比较版本
   */
  export const versionCompare = (cur, compare) => {
    const _cur = cur.split('.');
    const _compare = compare.split('.');
    if (+_cur[0] < +_compare[0]) {
      return false;
    } else if ( +_cur[0] === +_compare[0] && +_cur[1] < +_compare[1] ) {
      return false;
    } else if (+_cur[0] === +_compare[0] && +_cur[1] === +_compare[1] && +_cur[2] < +_compare[2]) {
      return false;
    }
    return true;
  }
  
  //暂时只有一个音乐，临时处理
  // let bgMusic;
  // let gameMusic;
  let bgs = {
  }
  export const playBgMusic1 = (isOn, src) => {//待测试
  
      for (let k in bgs) {
          if (bgs[k].isOn) {
              bgs[k].stop();
          }
          // bgs[k].isOn = false;	/// TODO 自己记一个开关，因为淘宝的玩意stop之后虽然听不到，但还是在播放，会触发loop播放和onEnded事件
      }
  
      const key = src;
      if (isOn) {
          if (!bgs[key]) {
              bgs[key] = createAudio({
                  src: src,
                  autoplay: true,
                  loop: false /// TODO 暂时无效？2020.08.12 目前有效，但stop后还会跑数据，导致到音频结束到时间又自动播放
              });
  
  
              bgs[key].onPlay(() => {
                  bgs[key].isOn = true;
              });
  
              bgs[key].onStop(() => {
                  bgs[key].isOn = false;
              });
  
  
              /// TODO监听结束，因为loop无效  2020.08.12 loop有效，这个操作是为了解决stop之后还会跑音频数据的问题
              bgs[key].onEnded(() => {
                  if (bgs[key].isOn) {	// 判断自己记录的开关
                      bgs[key].play();
                      // bgs[key].isOn = true;
                  }
              });
  
              bgs[key].play();	// 安卓有时候autoplay好像莫得用
  
              // console.log(src)
              // bgs[key].isOn = true;	/// TODO 自己记一个开关，因为淘宝的玩意stop之后虽然听不到，但还是在播放，会触发loop播放和onEnded事件
  
          } else {
              bgs[key].play();
              // bgs[key].isOn = true;	/// TODO 自己记一个开关，因为淘宝的玩意stop之后虽然听不到，但还是在播放，会触发loop播放和onEnded事件
          }
      } else {
          if (bgs[key]) {
              // bgs[key].pause();	/// pause 垃圾，不能用
              bgs[key].stop();
              // bgs[key].isOn = false;	/// TODO 自己记一个开关，因为淘宝的玩意stop之后虽然听不到，但还是在播放，会触发loop播放和onEnded事件
          }
      }
  }
  
  
  // TODO: 确认天猫是否也是9.3.0以下有问题
  export const checkSystem = async ()=> {
    const { version, app } = await getSystemInfo();
    console.log('version', version);
    return versionCompare(version, '9.3.0');
  }
  
  /**
   * 获取淘宝用户收货地址
   */
  export const getUserAddress = async (opts = {}) => {
    let defaults = {
      addAddress: 'show',
      searchAddress: 'hide',
      locateAddress: 'hide',
      joinTag: '' // 分割收货地址符号（淘宝商家有特定发货需求）
    };
    const isValidVersion = await checkSystem();
    if(!isValidVersion) {
      commonToast('当前版本不支持选择收货地址，请升级到最新版本');
      return;
    }
   
    let _opts = Object.assign({}, defaults, opts);
    return new Promise((resolve, reject) => {
      my.authorize({
        scopes: 'scope.addressList',
        success: () => {
          const { addAddress,  searchAddress, locateAddress, joinTag } = _opts;
          if (!my.tb.chooseAddress) {
            reject({ support: false, errorMessage: '当前版本不支持选择收货地址，请升级到最新版本' });
            return false;
          }
          my.tb.chooseAddress({
            addAddress,
            searchAddress,
            locateAddress
          }, res => {
            const { error, provinceName, countyName, cityName, streetName, detailInfo, name, telNumber } = res;
            // 如果有error为用户取消操作不做操作
            if (error) {
              resolve(false);
            } else {
              resolve({
                ...res,
                duibaAddress: {
                  name,
                  phone: telNumber,
                  address: [provinceName, cityName, countyName, streetName, detailInfo].join(joinTag)
                }
              });
            }
          }, res => {
            reject(res);
          })
        },
      });
    });
  };
  
  
  /**
   * 打开详情页
   * @param {string} itemId 
   */
  export const openDetail = (itemId) => {
    return new Promise((resolve, reject) => {
      my.tb.openDetail({
        itemId,
        success: (res) => {
          resolve(res)
        },
        fail: (res) => {
          reject(res)
        },
      });
    })
  }
  /**
   * 自定义埋点的方法
   * @param {string}} logkey 
   */
  export const reportAnalytics = (logkey) => {
    my.reportAnalytics('click', {
      // 标志某一类事件，方便数据分析进行分组
      'logkey': logkey
    })
  }
  
  export const cloudRequest = async (_cloudName, params, handle, loading = false) => {
    const { cloud } = getApp();
    loading && my.showLoading()
    return new Promise((resolve, reject) => {
        cloud.function.invoke(_cloudName, params, handle).then(res => {
            console.log(`调用${handle}接口返回结果`, res)
            loading && my.hideLoading()
            if (res && res.success) {
            resolve(res);
            } else {
            reject(res);
            }
            return res;
        }).catch(() => {
            loading && my.hideLoading()
            reject();
        });
    });
  }
  
  export const checkMember = async () => {
    // @ts-ignore
    const  memberPlugin = requirePlugin("cemMember");
    return new Promise((resolve,reject) => {
      memberPlugin.checkMember({
        // sellerId,
        success: (res) => {
          let isMember = !!res.data.isMember && res.data.isMember === 'true'
          resolve(isMember)
        },
        fail: (res) => {
          reject(res)
        }
      })
    })
  }