##### useAudio

```jsx
    const {playAudio, openStatus, setOpenStatus, musicUrl} = useAudio(url,isBgMusic)
```
##### 入参
| 入参 | 类型 | 描述 | 默认值 | 备注 |
| :--- | :---: | :---: |:---: | :---: |
| url | String | cloud开头的链接 | 'cloud:xxxx.mp3' | 当前应用云存储上的链s接才有效 |
| isBgMusic | Boolean | 是否自动加载背景音乐/音效 | false | / |
##### 出参
| 出参 | 类型 | 描述 | 默认值 | 备注 |
| :--- | :---: | :---: |:---: | :---: |
| playAudio | Function | 播放音乐/音效 | 有回调函数callback | callback默认为空函数 |
| openStatus | Boolean | 默认开启播放 | true | / |
| setOpenStatus | Function | 改变开始/暂停状态 | / | true/false都会调用playMusic1方法|
| musicUrl | String | cloud文件得到的音频url链接 | 'https:xxxx.mp3' | 音频文件url链接|

+ 使用
```jsx
import {useAudio} from '@/hooks/useAudio'
import {CLOUD_OBJ} from '@/const'

export const Index = () => {

    const {playAudio,musicUrl,setOpenStatus,openStatus} = useAudio(CLOUD_OBJ['1'])

    const gotoMainPage = () => {
        setOpenStatus(!openStatus)
        playAudio(()=>{
            // ...场景：点击有音效，跳转的页面有背景音乐
            navigateTo({url:`/pages/other/other`})
        });
        // TODO...
    }
    return(
        <>
            <View onTap={gotoMainPage}>点击音效button</View>
        </>
    )
}

import {useAudio} from '@/hooks/useAudio'
import {BGMUSIC_URL} from '@/const'
export const Other = () => {
    // 自动播放背景音乐
    const {playAudio,setOpenStatus,openStatus} = useAudio(CLOUD_OBJ['1'],true)
    return(
        <View>
            other page
        </View>
    )
}
```

+ 所有音效状态统一, 则需要在useAudio中设置一个全局变量(app.openStatus)

+ 音效缓存,音效关闭，下次进入音效还是关闭
```js

    let status =  my.getStorageSync({ key: 'musicStatus' });
    console.log('status',status);
    
    if(status.data == undefined || status.data === null || status.data === ''){
      app.openStatus = true;
      my.setStorageSync({ key: 'musicStatus',data:true })
    } else if(status?.data == true){
      app.openStatus = true;
    } else if(status?.data == false){
      app.openStatus = false;
    }

    
    const {openStatus,setOpenStatus} = useAudio(CLOUD_OBJ['2'],true)
    /**
     * @description 切换音效状态
     */
    const handleMusic = () => {
    setOpenStatus(status => !status)
    /* 切换音效状态 */
    app.openStatus = !app.openStatus;
    let musicStatus =  my.getStorageSync({ key: 'musicStatus' }).data;
    console.log('musicStatus-----初始值---->>>>>>>>>>',musicStatus);
    my.setStorageSync({ key: 'musicStatus',data:!musicStatus });
    
    let musics =  my.getStorageSync({ key: 'musicStatus' }).data;
    console.log('musicStatus----改变值----->>>>>>>>>>',musics);
  }
```

+ 背景音效后台关闭
```jsx
    const {openStatus,setOpenStatus} = useAudio(CLOUD_OBJ['2'],true)

    useDidHide(()=>{
        // 停止背景音乐
        openStatus && setOpenStatus(false)
    })

    useDidShow(()=>{
        // 播放背景音乐(缓存处理)
        let musicStatus =  my.getStorageSync({ key: 'musicStatus' }).data;
        if(musicStatus){
            setOpenStatus(true)
        }

        // 非缓存 默认开启
        setOpenStatus(true)
    })
```