import React, { useEffect, useState } from 'react'
import { View } from '@tarojs/components'
import ContainerFit from '@/components/_base/ContainerFit/ContainerFit'
import TitleImg from '@/components/_tb_comps/TitleImg/TitleImg'
import GoodsList from '@/components/_tb_comps/GoodsList/GoodsList'
import { useRequest } from '@/hooks/useRequest'
import { useRouter } from '@tarojs/taro'
import API from '@/api'
import styles from './orderGoods.module.less'
import ORDER_CONFIG from '@/config/order.config'

function OrderGoodsPage() {
  const router = useRouter()
  const { itemIds } = router?.params
  const { data } = useRequest(API.getCollectGoods, { key: ORDER_CONFIG.taskType, itemIds })

  return (
    <ContainerFit bg={ORDER_CONFIG.bg}>
      <View className={styles['page-content__title']}>
        <TitleImg config={ORDER_CONFIG.head}/>
      </View>
      <View className={styles['page-content__list']}>
        <GoodsList goodsList={data?.list || []} task={ORDER_CONFIG} />
      </View>
    </ContainerFit>

  )
}

export default OrderGoodsPage
