import { View } from '@tarojs/components'
import React, { memo, useContext, useMemo } from 'react'
import classnames from 'classnames'
import tbcc from 'tbcc-sdk-ts'

import { ProgressContext } from '../ProgressContext'

// css
import styles from './index.module.less'

const { throttleHandle } = tbcc.utils

const ProgressNode = memo(props => {
  /**
   * isReach 是否达到当前进度
   * levelValue 节点值
   * levelPos 节点偏移
   * onReceviceClick 达到当前进度才可点击触发
   */
  const { isReach, levelValue, levelPos, onReceviceClick = () => {} } = props

  const { maxLevel, nodeClassName } = useMemo(
    () => useContext(ProgressContext),
    ProgressContext
  )

  const getNodeStyle = classnames(styles['defualt-progress-node'], {
    [nodeClassName]: nodeClassName
  })

  const onNodeClick = throttleHandle(() => {
    isReach && onReceviceClick()
  }, 2000)

  return (
    <View
      onTap={onNodeClick}
      className={getNodeStyle}
      style={{
        left: levelPos || (levelValue / maxLevel) * 100 + '%'
      }}
    >
      {/* 自定义 */}
    </View>
  )
})

export default ProgressNode
