import { useEffect, useRef, useState } from 'react'
import Taro, { useDidShow, showToast } from '@tarojs/taro'
import { getSetting, openSetting, authorize, getAuthUserInfo } from 'tbcc-sdk-ts/lib/core/tb'

// 授权
export function useAuth(authSuccess = () => {}) {
  const [visible, setVisible ] = useState(false)
  const goToOpenSetting = useRef(false)
  // 获取授权信息
  const onHandleSetting = async () => {
    const res = await getSetting()
    if(!res.authSetting?.userInfo) {
      const authResult = await authorize().catch(err => {
        setVisible(true)
        showToast({ title: '请先授权，授权成功后才可参与活动' })
      })
      if(authResult) {
        authUserInfo()
      }
    }else {
      authUserInfo()
    }
  }
  // 打开授权设置
  const onOpenSetting = async () => {
    goToOpenSetting.current = true
    showToast({ title: '打开授权开关，授权成功后才可参与活动', duration: 1000, success: () => openSetting() })
  }
  // 获取用户授权信息
  const authUserInfo = async() => {
    const info = await getAuthUserInfo()
    if (info) {
      authSuccess(info)
      setVisible && setVisible(false)
    }
  }
  useEffect(() => {
    onHandleSetting()
  }, [])

  useDidShow(() => {
    if(goToOpenSetting.current) {
      // 重新授权
      onHandleSetting()
      goToOpenSetting.current = false
    }
  })

  return {
    visible,
    onHandleSetting,
    onOpenSetting
  }
}