import { View, ScrollView, Image } from '@tarojs/components'
import React, { useState, useEffect, useRef } from 'react'
import { noopFn } from '@/utils/util'
import tbccTs from 'tbcc-sdk-ts'
import API from '@/api'
import config from '@/config/config'
import { useThrottle } from '@/hooks/useThrottle'
import Popup from '@/components/_base/Popup/Popup'
import { SHOP_ID } from '@/const'
import styles from './TasksModal.module.less'
import { useDidShow } from '@tarojs/taro'
import { TASK_DATA } from '@/mock'
import { checkIsMember } from 'tbcc-sdk-ts/lib/utils'
import { TASK_CONFIG, ORDER_GOOD_TYPE, BROSE_GOOD_TYPE, TASK_STATUS } from '@/config/task.config'

const { commonToast, favorShop, navigateTo, navigateToOutside, showSharePanel, navigateToTaobaoPage } = tbccTs.tb

export default function TasksModal(props) {
  const app = getApp()
  const { onClose = noopFn, onUpdate, taskFlag } = props
  const [ memberShopVisible, setMemberShopVisible ] = useState(false)
  const [ currentTaskType, setCurrentTaskType ] = useState('')
  const preBrowseTime = useRef(null)

  const [ taskList, setTaskList ] = useState(TASK_DATA)
  const { icons, commonTxt, doTxt, jumpType, browseTime, showTaskType, browseType, orderType } = TASK_CONFIG

  useDidShow(() => {
    if (app.isFlashTask) {
      app.isFlashTask = false
      if (preBrowseTime.current && ((Date.now() - preBrowseTime.current) / 1000) >= browseTime && currentTaskType !== 'browseGoods') {
        doCompleteTaskHandle(currentTaskType, true)
        preBrowseTime.current = null
      } else if(preBrowseTime.current && ((Date.now() - preBrowseTime.current) / 1000) < browseTime) {
        commonToast(`未达到${browseTime}秒~`)
        preBrowseTime.current = null
      }else {
        fetchTaskList()
      }
    }
  })
  useEffect(() => {
    if(showTaskType === 2 && taskFlag) {
      fetchTaskList()
    }else if(showTaskType === 1){
      fetchTaskList()
    }
  },[taskFlag])

  const fetchTaskList = async () => {
    const isVip = await checkIsMember()
    const { success, data } = await API.getTaskList({ isVip })
    if(success && data) {
      const { list = [] } = data
      // setTaskList(list)
    }
  }

  const handleTapItem = useThrottle(async(item) => {
    const { status, taskType } = item
    const tapFn = {
      [TASK_STATUS.WAIT_RECEIVE]: async() => {
        const { success, data } = await API.receiveTaskRewards({ taskType, rewardsKey: 'totalHotValue' })
        if (success && data) {
          const { rewards } = data
          commonToast(`领取成功，奖励值+${rewards}`)
          fetchTaskList()
          onUpdate && onUpdate()
        }
      },
      [TASK_STATUS.WAIT_DO]: () => goToComplete(item)
    }

    tapFn[status] && tapFn[status]()
  })

  const goToComplete = async(item) => {
    const { taskType, url, itemIds, keepTime } = item
    setCurrentTaskType(taskType)
    const completeFn = {
      member: () => setMemberShopVisible(true),
      invites: () => showSharePanel(),
      follow: async() => {
        const isFollow = await favorShop(config.sellerId)
        if (isFollow) {
          doCompleteTaskHandle(taskType)
        }
      },
      // 跳转任务 https://www.feizhu.com
      jumpLink: async() => {
        navigateToOutside(url)
        if (jumpType === 2) {
          doCompleteTaskHandle(taskType)
        } else {
          app.isFlashTask = true
          preBrowseTime.current = Date.now()
        }
        // await API.addStat({ type: 'BROWSE_LIVE'})
      },
      browseGoods: async() => {
        app.isFlashTask = true
        if(browseType === BROSE_GOOD_TYPE.PAGE) preBrowseTime.current = Date.now()
        navigateTo(`/pages/packageGood/browseGoods/browseGoods?itemIds=${itemIds}&keepTime=${keepTime}`)
      },
      orderGoods: async() => {
        app.isFlashTask = true
        if(orderType === ORDER_GOOD_TYPE.PAGE) {
          navigateTo(`/pages/packageGood/orderGoods/orderGoods?itemIds=${itemIds}`)
        }else {
          await navigateToTaobaoPage(SHOP_ID)
        }
      },
      collectGoods: async() => {
        app.isFlashTask = true
        navigateTo(`/pages/packageGood/collectGoods/collectGoods?itemIds=${itemIds}`)
      },
      sign: () => doCompleteTaskHandle(taskType),
      share: () => {
        showSharePanel();
        setTimeout(() => {
          doCompleteTaskHandle(taskType)
        }, 2000);
      }
    }
    completeFn[taskType] && completeFn[taskType]()
  }

  const doCompleteTaskHandle = async(taskType, flag) => {
    const { success } = await API.doCompleteTask({ taskType })
    if (success) {
      await fetchTaskList()
    }
  }

  const onCloseMemberModal = () => {
    setMemberShopVisible(false)
  }
  const onAuthSuccess = () => {
    setMemberShopVisible(false)
    fetchTaskList()
  }
  const onAuthFail = () => {
    setMemberShopVisible(false)
  }
  const onCloseModal = () => {
    onClose && onClose()
  }

  return (
    <>
      <Popup onClose={onCloseModal} height='700rpx'>
        <View className={styles['modal-container']}>
          <View className={styles['modal-content']}>
            <View className={styles['modal-content__title']}>任务模块</View>
            <View className={styles['modal-content__list']}>
              <ScrollView scroll-y='{{true}}' className={styles['modal-content__scroll']}>
                {
                taskList.map((item, i) => {
                  return (
                    <View className={styles['item']} key={'task_I' + i}>
                      <View className={styles['item__left']}>
                        <Image src={icons[item.taskType]} mode='widthFix' />
                      </View>
                      <View className={styles['item__left-label']}>
                        <View className={styles['item__left-title']}>{item.title}</View>
                        <View className={styles['item__left-reward']}>抽盒次数+{item.rewards}</View>
                      </View>
                      <View className={`${styles['list-item__right']} ${styles['item__status-' + item.status]}`} onClick={() => handleTapItem(item)}>
                        {
                          item.status === TASK_STATUS.WAIT_DO ? (doTxt[item.taskType] || '去完成') : commonTxt[item.status]
                        }
                      </View>
                    </View>
                  )
                })
              }
              </ScrollView>
            </View>
          </View>
        </View>
      </Popup>
      {memberShopVisible && <member-modal onClose={onCloseMemberModal} onAuthFail={onAuthFail} onAuthSuccess={onAuthSuccess} />}
    </>
  )
}
