import cloud from '@tbmp/mp-cloud-sdk'
import tbccTs from 'tbcc-sdk-ts'
import conifg from './config/config'

const { utils: { generateAPI }, request: tbccRequest, capi } = tbccTs
const { cloudName, requestType } = conifg

const request = tbccRequest({
  cloud,
  cloudName,
  requestType
})
/**
 const defaultConfig = {
    method: 'GET',
    showLoading: false,  请求是否loading
    toastError: true  success为false时是否toastMessage
  }
 * **/
// api handle 列表
const apiList = {
  ...capi,
  receiveObjectPrize: {
    handle: 'receiveObjectPrize',
    method: 'GET',
    isShowLoading: false,
    toastError: false
  },
  receiveEnamePrize: {
    handle: 'receiveEnamePrize',
    method: 'GET',
    isShowLoading: false,
    toastError: false
  },
  getActivityBaseInfoById: {
    handle: 'getActivityBaseInfoById',
    method: 'GET',
    isShowLoading: false
  },
  login: 'login',
  addStat: 'addStat',
  drawLottery: 'drawLottery',
  getShareInfo: 'getShareInfo',
  getCollectGoods: 'getCollectGoods',
  receiveMemberEname: 'receiveMemberEname', // 会员权益领取
  getPrizeConfig: 'getPrizeConfig', // 获取奖品配置
  drawRotatePrize:'drawLottery',//大转盘抽奖接口,暂未实现
  exchangePrize: 'exchangePrize', // 兑换奖品
  getUserInfo: 'getUserInfo', // 获取用户信息
  getUserRankList: 'getUserRankList', // 获取排名列表
  startGame: 'startGame', // 开始游戏
  submitGame: 'submitGame', // 提交游戏
}

// 生成API
const API = generateAPI(apiList, request)

export default API
