import { useEffect, useState, useReducer } from 'react'
import { useRouter } from '@tarojs/taro'
import { useLoginInfoModel } from '../store/loginInfo'
import API from '../api'
import config from '@/config/config'
import { useAuth } from './useAuth'
import { noopFn } from '@/utils/util'
import { checkShopFavoredStatus } from 'tbcc-sdk-ts/lib/core/tb'
import { checkIsMember } from 'tbcc-sdk-ts/lib/utils'

const { login } = API

/**
 *  授权登录
 *
 * @export
 * @param {*} [callback=noopFn] 登录之后的回调
 * @return {*} isLogin 是否登录
 */
export function useLogin(callback = noopFn) {
  const { setLoginInfo } = useLoginInfoModel()

  const [ isLogin, setLoginStatus ] = useState(false)
  const { params } = useRouter()

  const doLogin = async (authInfo) => {
    const isFollow = await checkShopFavoredStatus(config.sellerId)
    const isVip = await checkIsMember()
    const { nickName: userNick, avatar } = authInfo
    const { inviteId } = params
    const res = await login({ userNick, avatar, isFollow, inviteId, isVip })
    if (res?.success) {
      const { newUser,firstLoginToday, openId } = res.data
      const _loginInfo = {
        newUser,firstLoginToday, openId,
        userNick,
        avatar,
        inviteId
      }
      setLoginInfo({ ..._loginInfo, isLogin: true })
      setLoginStatus(true)
      console.log('isLogin :>> ', true)
      callback(_loginInfo)
    }
  }
  const authInfo = useAuth((authInfo) => {
    console.warn('authInfo :>>'+authInfo)
    doLogin(authInfo)
  })
  return { isLogin, authInfo }
}

export function useLoginFromShare(callback = noopFn) {
  const { loginInfo } = useLoginInfoModel()
  // 只执行一次
  const [ executed, setExecuted ] = useState(false)

  useEffect(() => {
    if (loginInfo.inviteId && !executed) {
      callback(loginInfo.inviteId)
      setExecuted(true)
    }
  }, [ loginInfo ])

  return {
    inviteId: loginInfo.inviteId
  }
}
