/** @format */

import { resultsModel } from '../../sdk'
import { recordErrorLog } from './logger'
import { CODE_TYPES } from '../../errorCode'
import { cloundAlarm } from '../../utils/common/dingTalk'
/** @format */

export async function doHandler(target: Object, method: IFunction, args: any[]) {
  let ret: IResult<any>
  try {
    ret = await method.apply(target, args)
  } catch (error) {
    console.log('error', error)
    recordErrorLog(args[0], args[1], error.toString(), error.stack)
    // 云告警
    cloundAlarm(args[0], error.toString())

    ret = resultsModel.error(CODE_TYPES.SYSTEM_ERROR)
  }
  return ret
}
