/** @format */

import { resultsModel } from '../../../sdk'
import { CODE_TYPES } from '../../../errorCode'
import { isBoolean } from 'lodash'

/**
 *  检查是否关注店铺，接口需传入isFollow参数
 *
 * @export
 * @param {IContext<IParams>} context
 * @return {*}  {Promise<IPreCheckResult>}
 */
export default async function checkFollow(context: IContext<IParams>): Promise<IPreCheckResult> {
  const { isFollow } = context.data

  if (!isBoolean(isFollow)) return resultsModel.error(CODE_TYPES.PARAMS_ERROR, '缺少isFollow参数')
  if (!isFollow) {
    return resultsModel.error(CODE_TYPES.ERROR_NO_FOLLOW)
  }
}
