import { phone, activityName } from '../../constants'
/**
 * 告警信息
 * @param message 
 */
export const cloundAlarm = async (context: IContext<IParams>, message: string) => {
    // https://oapi.dingtalk.com/robot/send?access_token=f6d0d8ecdab3ad77dc51b5173f630f1c0e0fcbe90e994d0a642fb0b516dfd24c
    const text = {
        "msgtype": "markdown",
        "markdown": {
          "title":"云告警",
          "text": `### 活动名称：${activityName} \n ### 告警内容 \n ####${message}\n @${phone}`
        },
        "at": { "isAtAll": false, "atMobiles": [phone], "atUserIds": [] }
    }
    const result = await context.cloud.httpApi.invoke(
        {
           'domain':'https://oapi.dingtalk.com',
           'path': '/robot/send',
           'params': {
            'access_token': 'f6d0d8ecdab3ad77dc51b5173f630f1c0e0fcbe90e994d0a642fb0b516dfd24c'
           },
           'method':'POST',
           'headers': {
              'Content-Type':'application/json;charset=UTF-8',
           },
           'body': text
    });
    return result
}
