/**
 * 任务相关方法
 *
 * @format
 */
import UserService from './user.service';
interface ITaskInfo {
    taskType?: string;
    url?: string;
    rewards: number;
    done?: boolean;
    itemIds?: string;
    waitReceive?: number;
    title: string;
}
export default class TaskService extends UserService {
    constructor(context: Context);
    initVipTask(userInfo: IUserInfo, vipInfo: IVipInfo, tasks: ITasks): ITaskInfo;
    initOrderGoodsTask(userInfo: IUserInfo, tasks: ITasks): ITaskInfo;
    initBrowseGoodsTask(userInfo: IUserInfo, tasks: ITasks): ITaskInfo;
    initInvitesTask(userInfo: IUserInfo, tasks: ITasks): ITaskInfo;
    initFollowTask(userInfo: IUserInfo, tasks: ITasks): {
        taskType: string;
        title: string;
        rewards: number;
        waitReceive: number;
        done: boolean;
    };
    initExchangeCreditsTask(userInfo: IUserInfo, tasks: ITasks): {
        taskType: string;
        title: string;
        rewards: number;
        waitReceive: number;
        done: boolean;
    };
    updateVipTaskStatus(userInfo: IUserInfo, vipInfo: IVipInfo, tasks: ITasks): {
        member: IMemberInfo;
        remainTimes: IRemainTimesInfo;
    };
    updateOrderGoodsTask(userInfo: IUserInfo, tasks: ITasks, session?: string): Promise<{
        remainTimes?: undefined;
        taskInfo?: undefined;
    } | {
        remainTimes: IRemainTimesInfo;
        taskInfo: object;
    }>;
    /**
     *更新关注店铺任务状态
     *
     * @param {IUserInfo} userInfo
     * @param {IActivityInfo} activityInfo
     * @returns
     * @memberof TaskService
     */
    updateFollowTask(userInfo: IUserInfo, activityInfo: IActivityInfo): Promise<any>;
    /**
     *
     * 获取任务今天完成的次数
     *
     * @param {string} taskType  任务类型
     * @param {IUserInfo} userInfo 用户信息
     * @returns {number} todayTimes  今日任务完成次数  todayTaskInfo  今日对应任务完成详情
     * @memberof TaskService
     */
    getTodayCompleteTask(taskType: string, userInfo: IUserInfo): {
        todayTimes: any;
        todayTaskInfo: any;
    };
    /**
     * 根据任务类型获取任务完成情况
     *
     * @param {IUserInfo} userInfo
     * @param {string} taskType
     * @returns {array}
     * @memberof TaskService
     */
    getCompleteTaskByUserTaskInfo(taskType: string, userInfo: IUserInfo): any[];
    /**
     *根据任务类型更新任务待领取次数和任务记录
     *
     * @param {string} taskType
     * @param {number} rewards
     * @param {IUserInfo} userInfo
     * @param {object} [customRecord]
     * @returns {boolean}
     * @memberof TaskService
     */
    updateUserTaskRecord(taskType: string, rewards: number, userInfo: IUserInfo, customRecord?: object): Promise<boolean>;
    updateTasks(id: string, needUpdateKeysArray: object[]): Promise<any>;
}
export {};
