"use strict";
/** @format */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var sdk_1 = require("../sdk");
var db_1 = require("../db");
var constants_1 = require("../constants");
var utils_1 = require("../utils");
var ActivityTopService = /** @class */ (function () {
    function ActivityTopService(context) {
        this.activitySellerDao = new sdk_1.BaseDao(context, db_1.SELLER_INFO_DB_NAME);
        this.activityBaseDao = new sdk_1.BaseDao(context, db_1.ACTIVITY_CONFIG_DB_NAME);
        this.context = context;
    }
    //获取商家授权session
    ActivityTopService.prototype.getAccessTokenByShopId = function (activityId) {
        return __awaiter(this, void 0, void 0, function () {
            var result, shopId, sellResult;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.activityBaseDao.findOne({ _id: activityId })];
                    case 1:
                        result = _a.sent();
                        if (!result)
                            return [2 /*return*/, {}];
                        shopId = (result || {}).shopId;
                        return [4 /*yield*/, this.activitySellerDao.findOne({ shopId: shopId }, { sort: { createTime: 1 } })];
                    case 2:
                        sellResult = (_a.sent()).sellResult;
                        console.log(sellResult, 'sellResult');
                        return [2 /*return*/, { session: sellResult === null || sellResult === void 0 ? void 0 : sellResult.accessToken }];
                }
            });
        });
    };
    //通过openId去查找session
    ActivityTopService.prototype.getAccessTokenByOpenId = function () {
        return __awaiter(this, void 0, void 0, function () {
            var openId, result;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        openId = this.context.openId;
                        return [4 /*yield*/, this.activitySellerDao.findOne({ openId: openId })];
                    case 1:
                        result = _a.sent();
                        return [2 /*return*/, { session: (result === null || result === void 0 ? void 0 : result.accessToken) || this.context.accessToken }];
                }
            });
        });
    };
    //淘宝top接口获取商品列表
    ActivityTopService.prototype.getItemListByIds = function (itemIds, seesion) {
        return __awaiter(this, void 0, void 0, function () {
            var result, itemsData, e_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, sdk_1.TBAPIS.getItemListByItemIds(this.context, seesion, itemIds, { fields: constants_1.GOODSINFO })];
                    case 1:
                        result = _a.sent();
                        if (result) {
                            itemsData = {
                                list: (result &&
                                    result.items &&
                                    result.items.item.reduce(function (s, v) {
                                        return (s = __spreadArrays(s, [
                                            {
                                                itemId: v.num_iid,
                                                name: v.title,
                                                price: v.price,
                                                detailUrl: v.detail_url,
                                                picUrl: v.pic_url
                                            }
                                        ]));
                                    }, [])) ||
                                    [],
                                totalCount: result.items.item.length
                            };
                            return [2 /*return*/, sdk_1.resultsModel.success(itemsData)];
                        }
                        return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, '获取商家ids列表失败')];
                    case 2:
                        e_1 = _a.sent();
                        console.log(e_1, '获取ids商品列表失败');
                        return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, '获取商家ids列表失败')];
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    //淘宝top接口获取权益商品信息
    ActivityTopService.prototype.getPrizeByEname = function (session, ename) {
        var _a, _b;
        return __awaiter(this, void 0, void 0, function () {
            var benefitData, result, data;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        // sellerConfig = await this.getAccessTokenByOpenId()
                        // ename = this.context.data.ename
                        console.log(session, 'session');
                        return [4 /*yield*/, sdk_1.TBAPIS.getPrizeByEname(this.context, session, ename, constants_1.B_APP_NAME)];
                    case 1:
                        benefitData = _c.sent();
                        console.log(benefitData, benefitData.result, 'benefitData.result.');
                        if ((_a = benefitData === null || benefitData === void 0 ? void 0 : benefitData.result) === null || _a === void 0 ? void 0 : _a.success) {
                            result = benefitData.result;
                            data = (_b = result === null || result === void 0 ? void 0 : result.datas) === null || _b === void 0 ? void 0 : _b['oright_dto'].reduce(function (s, v) {
                                return (s = __spreadArrays(s, [
                                    {
                                        benefitName: v.benefit_name,
                                        rightTypeId: v.right_type_id == 3 ? 1 : v.right_type_id,
                                        startTime: new Date(v.start_date).getTime(),
                                        endTime: new Date(v.end_date).getTime(),
                                        amount: v.amount ? v.amount / 100 + '' : ''
                                    }
                                ]));
                            }, []);
                            console.log(JSON.stringify(result), 'alibaba.benefit.query');
                            return [2 /*return*/, sdk_1.resultsModel.success(data)];
                        }
                        return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, '获取ename商品信息失败')];
                }
            });
        });
    };
    //淘宝top接口获取店铺信息
    ActivityTopService.prototype.getShopId = function () {
        return __awaiter(this, void 0, void 0, function () {
            var sellerInfo, result, e_2;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getAccessTokenByOpenId()];
                    case 1:
                        sellerInfo = _a.sent();
                        console.log(sellerInfo, 'getShopId sellerInfo');
                        _a.label = 2;
                    case 2:
                        _a.trys.push([2, 4, , 5]);
                        return [4 /*yield*/, sdk_1.TBAPIS.getShopInfo(this.context, {
                                session: sellerInfo.session,
                                fields: 'sid,title,pic_path'
                            })];
                    case 3:
                        result = _a.sent();
                        console.log(result, 'getShopId result');
                        if (result) {
                            return [2 /*return*/, sdk_1.resultsModel.success(result.shop)];
                        }
                        else {
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, '获取淘宝top店铺信息失败')];
                        }
                        return [3 /*break*/, 5];
                    case 4:
                        e_2 = _a.sent();
                        console.log(e_2, '获取店铺信息失败');
                        return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, '获取淘宝top店铺信息失败')];
                    case 5: return [2 /*return*/];
                }
            });
        });
    };
    ActivityTopService.prototype.getItemListByStatus = function (session, _a) {
        var _b;
        var _c = _a.approveStatus, approveStatus = _c === void 0 ? 'onsale' : _c, _d = _a.title, title = _d === void 0 ? '' : _d, _e = _a.pageNo, pageNo = _e === void 0 ? 1 : _e, _f = _a.pageSize, pageSize = _f === void 0 ? 10 : _f;
        return __awaiter(this, void 0, void 0, function () {
            var data, result, _g, items, total_results, itemsData;
            return __generator(this, function (_h) {
                switch (_h.label) {
                    case 0:
                        data = { fields: constants_1.GOODSINFO, pageNo: pageNo, q: title, title: title, pageSize: pageSize, session: session };
                        console.log(data, 'data');
                        if (!(approveStatus === 'onsale')) return [3 /*break*/, 2];
                        return [4 /*yield*/, sdk_1.TBAPIS.getItemListOnSale(this.context, data)];
                    case 1:
                        _g = _h.sent();
                        return [3 /*break*/, 4];
                    case 2: return [4 /*yield*/, sdk_1.TBAPIS.getItemListInStock(this.context, data)];
                    case 3:
                        _g = _h.sent();
                        _h.label = 4;
                    case 4:
                        result = _g;
                        if (!result)
                            return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, '获取商家在售列表失败')];
                        items = result.items, total_results = result.total_results;
                        itemsData = {
                            pageNo: pageNo,
                            pageSize: pageSize,
                            totalPages: Math.ceil(total_results / pageSize),
                            totalCount: total_results,
                            list: ((_b = items === null || items === void 0 ? void 0 : items.item) === null || _b === void 0 ? void 0 : _b.reduce(function (s, v) {
                                return (s = __spreadArrays(s, [
                                    {
                                        itemId: v.num_iid,
                                        name: v.title,
                                        price: v.price,
                                        approveStatus: v.approveStatus || approveStatus,
                                        picUrl: v.pic_url
                                    }
                                ]));
                            }, [])) || []
                        };
                        return [2 /*return*/, sdk_1.resultsModel.success(itemsData)];
                }
            });
        });
    };
    ActivityTopService.prototype.getTemplateInstantiate = function () {
        return __awaiter(this, void 0, void 0, function () {
            var sellerConfig, data, result, e_3;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getAccessTokenByOpenId()];
                    case 1:
                        sellerConfig = _a.sent();
                        data = __assign(__assign({ description: '此应用用于商家引导活动，商家可设置对应的奖品，在一定时间 内出奖，提升店铺用户活跃以及引导购买', ext_json: {
                                name: 'online'
                            }, icon: 'https://ossgw.alicdn.com/taobao-miniapp/img/0193eaa9cc037b568acd9ccfe68a8499.jpg', name: '店铺漂流' + utils_1.MathRand() }, constants_1.TEMPLATE_INFO), sellerConfig);
                        console.log('getTemplateInstantiateParams', data);
                        _a.label = 2;
                    case 2:
                        _a.trys.push([2, 4, , 5]);
                        return [4 /*yield*/, sdk_1.TBAPIS.getTemplateInstantiate(this.context, data)];
                    case 3:
                        result = _a.sent();
                        if (result) {
                            console.log(JSON.stringify(result), 'getTemplateInstantiate');
                            return [2 /*return*/, result];
                        }
                        return [2 /*return*/, false];
                    case 4:
                        e_3 = _a.sent();
                        console.log(e_3, '获取getTemplateInstantiate失败');
                        return [2 /*return*/, false];
                    case 5: return [2 /*return*/];
                }
            });
        });
    };
    //模板小程序上线
    ActivityTopService.prototype.pushOnlineInstance = function (instanceInfo) {
        return __awaiter(this, void 0, void 0, function () {
            var sellerConfig, data, result, e_4;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getAccessTokenByOpenId()];
                    case 1:
                        sellerConfig = _a.sent();
                        data = __assign(__assign(__assign({}, constants_1.TEMPLATE_INFO), instanceInfo), sellerConfig);
                        console.log('pushOnlineInstanceParams', data);
                        _a.label = 2;
                    case 2:
                        _a.trys.push([2, 4, , 5]);
                        return [4 /*yield*/, sdk_1.TBAPIS.pushInstanceOnline(this.context, data)];
                    case 3:
                        result = _a.sent();
                        if (result) {
                            console.log(JSON.stringify(result), 'pushOnlineInstance');
                            return [2 /*return*/, result];
                        }
                        return [2 /*return*/, false];
                    case 4:
                        e_4 = _a.sent();
                        console.log(e_4, 'pushOnlineInstance失败');
                        return [2 /*return*/, false];
                    case 5: return [2 /*return*/];
                }
            });
        });
    };
    ActivityTopService.prototype.getSubRelationship = function (nick) {
        return __awaiter(this, void 0, void 0, function () {
            var cloud, res;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        cloud = this.context.cloud;
                        return [4 /*yield*/, cloud.topApi.invoke({
                                api: 'taobao.vas.subscribe.get',
                                data: {
                                    article_code: constants_1.APP_SUB_CODE,
                                    nick: nick
                                }
                            })];
                    case 1:
                        res = _a.sent();
                        if (res && res['article_user_subscribes'] && res['article_user_subscribes']['article_user_subscribe'])
                            return [2 /*return*/, res['article_user_subscribes']['article_user_subscribe'][0]];
                        return [2 /*return*/, false];
                }
            });
        });
    };
    //模板小程序更新
    ActivityTopService.prototype.updateMiniInstance = function (instanceInfo) {
        return __awaiter(this, void 0, void 0, function () {
            var sellerConfig, data, result, e_5;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.getAccessTokenByOpenId()];
                    case 1:
                        sellerConfig = _a.sent();
                        data = __assign(__assign(__assign({}, constants_1.TEMPLATE_INFO), instanceInfo), sellerConfig);
                        _a.label = 2;
                    case 2:
                        _a.trys.push([2, 4, , 5]);
                        return [4 /*yield*/, sdk_1.TBAPIS.updateMiniInstance(this.context, data)];
                    case 3:
                        result = _a.sent();
                        if (result) {
                            console.log(JSON.stringify(result), 'updateMiniInstance');
                            return [2 /*return*/, result];
                        }
                        return [2 /*return*/, false];
                    case 4:
                        e_5 = _a.sent();
                        console.log(e_5, 'updateMiniInstance失败');
                        return [2 /*return*/, false];
                    case 5: return [2 /*return*/];
                }
            });
        });
    };
    return ActivityTopService;
}());
exports.default = ActivityTopService;
//# sourceMappingURL=taobaoTop.service.js.map