const { cloud } = getApp();
const { function: fc } = cloud;
const plugin = requirePlugin("myPlugin");
import { bizCode } from "/config";
import { queryBenefitByEname } from "/api";
import { chooseImage, getImageInfo, validateRangeNumber, isDot } from "/utils";
import { passUrlList, urlCheck } from "../../../utils/helper";
const EQUITY_TYPE = 1;
const CREDITS_TYPE = 2;
const OBJECT_TYPE = 3;
const LOWER_TYPE = 5;

const STOCK_LIMIT = 1;
const STOCK_NO_LIMIT = 2;

const INIT_DATA = {
  ename: "",
  stock: "",
  type: 1,
  image: "",
  desc: "",
  useUrl: "",
  credits: "",
  probability: "",
  name: "",
  switchStock: STOCK_NO_LIMIT,
  isBackUp: false,
  useStock: 0,
  rank: "",
  amount: "",
  itemId: "",
};

Component({
  mixins: [],
  data: {
    goodsVisible: false,
    itemIds: '',
    EQUITY_TYPE,
    CREDITS_TYPE,
    OBJECT_TYPE,
    LOWER_TYPE,
    showDialogMask: true,
    dialogTop: "",
    rankTips: {
      status: "success",
      content: "",
    },
    imageTips: {
      status: "success",
      content: "",
    },
    probabilityTips: {
      status: "success",
      content: "",
    },
    nameTips: {
      status: "success",
      content: "",
    },
    prizeNumberTips: {
      status: "success",
      content: "",
    },
    prizeDescTips: {
      status: "success",
      content: "",
    },
    useUrlTips: {
      status: "success",
      content: "",
    },
    creditsValueTips: {
      status: "success",
      content: "",
    },
    goodsIdTips: {
      status: "success",
      content: "",
    },
    rankValueTips: {
      status: "success",
      content: "",
    },
    prizeInitData: {
      ename: "",
      id: "",
      stock: "",
      activityOutId: "",
      type: 1,
      image: "",
      desc: "",
      useUrl: "",
      credits: "",
      probability: "",
      name: "",
      switchStock: STOCK_NO_LIMIT,
      isBackUp: false,
      useStock: 0,
      rank: "",
      amount: "",
      itemId: "",
    },
  },
  props: {
    prizeDialogData: {
      index: "",
      record: {},
    },
    maxRankLimit: "", // 限制最高排名
    type: "", // 奖品弹窗类型  probability: 概率  rank: 排名
    imageLimit: [250, 250],
    activityOutId: "",
    isEdit: false,
    visible: false,
    hasEditPrize: false,
    datasource: [],
    prizeDataType: null,
    conditionKeys: [],
    typeChecked: [],
    onCloseDialog: function () { },
    onUpdate: function () { },
  },
  didMount() {
    this.initPosition();
    this.resetPrizeInit();
    this.initBenefit();
  },
  methods: {
    initPosition() {
      const { scrollTop } = this.$page.data;
      this.setData({
        dialogTop: scrollTop * 2,
      });
    },
    initBenefit() {
      const that = this;
      const bridge = {
        bizCode, //此处输入想配置的商家应用appID
        //这个方法用于获取插件中用户选择的奖池enname
        async getCheckBenefitID({ ename, poolID }) {
          my.showToast({
            type: "success",
            content: "已选择权益奖品",
          });
          const { success, data, message } = await queryBenefitByEname({
            ename,
          });
          const {
            benefitName,
            rightTypeId,
            startTime,
            endTime,
            stock,
            amount
          } = data[0];
          if (success) {
            //切换不同优惠券内容置空
            if (ename == that.data.prizeInitData.ename) {
              that.setData({
                prizeInitData: {
                  ...that.data.prizeInitData,
                  name: benefitName,
                  type: EQUITY_TYPE,
                  startTime,
                  endTime,
                  stock: stock,
                  amount
                },
              });
            } else {
              that.setData({
                prizeInitData: {
                  ...that.data.prizeInitData,
                  name: benefitName,
                  type: EQUITY_TYPE,
                  startTime,
                  _id: null,
                  endTime,
                  stock: "",
                  useStock: 0,
                  switchStock: 2,
                  amount: 0
                },
              });
            }
            //先去判断优惠券是否更换,再赋值ename
            that.setData({
              prizeInitData: {
                ...that.data.prizeInitData,
                ename,
              },
            });
            that.$page.data.backPageTimeOut = setTimeout(() => {
              my.navigateBack({
                delta: 1,
              });
            }, 6000);
          } else {
            my.showToast({
              type: "fail",
              content: message,
            });
          }
        },
      };
      plugin.setBridge(bridge);
    },
    // 编辑更换类型时重置数据
    resetPrizeData(type, rank) {
      this.setData({
        prizeInitData: {
          ...INIT_DATA,
          type,
          _id: null,
          rank,
        },
      });
    },

    onPrizeTypeChange(e) {
      let value = e.detail.value;
      const { type, rank } = this.data.prizeInitData;
      let initData = {
        ename: "",
        stock: "",
        useStock: 0,
        type: +value,
        image: "",
        desc: "",
        useUrl: "",
        credits: "",
        probability: "",
        name: "",
        isBackUp: false,
        switchStock: STOCK_NO_LIMIT,
      };
      if (type !== value) {
        this.resetPrizeData(+value, rank);
        return;
      }
      this.setData({
        prizeInitData: {
          ...this.data.prizeInitData,
          ...initData,
        },
      });
    },
    navigateToPlugin() {
      clearTimeout(this.$page.data.backPageTimeOut);
      my.navigateTo({
        url: "plugin://myPlugin/orightindex-page",
      });
    },
    resetPrizeInit() {
      const { isEdit, prizeDialogData } = this.props;
      console.log(isEdit, prizeDialogData);
      if (isEdit) {
        console.log(prizeDialogData);
        const { ...rest } = prizeDialogData.record;
        this.setData({
          prizeInitData: {
            ...rest,
          },
        });
      } else {
        this.setData({
          prizeInitData: INIT_DATA,
        });
      }
    },
    onswitchStockChange(e) {
      const value = e.detail.value;
      this.setData({
        prizeInitData: {
          ...this.data.prizeInitData,
          switchStock: value,
          stock: value === 2 ? "" : this.data.prizeInitData.stock || "",
        },
      });
    },
    onswitchIsBackUpChange(e){
      this.setData({
        prizeInitData:{
          isBackUp: e.detail.value
        }
      })
    },
    async uploadImage() {
      try {
        this.setData({
          showDialogMask: false,
        });
        const res = await chooseImage();
        this.setData({
          showDialogMask: true,
        });

        if (!res.apFilePaths.length) return;

        const { height, width, type, path } = await getImageInfo({
          src: res.apFilePaths[0],
        });
        const { imageLimit, maxRankLimit } = this.props;

        let imgBool = ~path.indexOf(".png") || ~path.indexOf(".jpg");
        if (height !== imageLimit[1] || width !== imageLimit[0] || !imgBool) {
          this.showItemTips("imageTips", "error", "请按要求上传图片");
          return;
        } else {
          this.showItemTips("imageTips", "success", "");
        }

        const { url } = await cloud.file.uploadFile({
          filePath: res.apFilePaths[0],
          fileType: "image",
          fileName: path.split("/").pop(),
        });

        this.setData({
          prizeInitData: {
            ...this.data.prizeInitData,
            image: url,
          },
          showDialogMask: true,
        });
      } catch (error) {
        this.setData({
          showDialogMask: true,
        });
        console.error(error);
      }
    },
    onChangePrizeValue(e) {
      const key = e.target.dataset.name;
      const value = e.detail.value;
      this.setData({
        prizeInitData: {
          ...this.data.prizeInitData,
          [key]: value,
        },
      });
    },
    changeInput(e) {
      this.setData({
        prizeInitData: {
          ...this.data.prizeInitData,
          name: e.detail.value,
        },
      });
    },
    updatePrize() {
      const {
        name,
        ename,
        image,
        desc,
        useUrl,
        type,
        startTime,
        probability,
        stock,
        credits,
        useStock,
        switchStock,
        isBackUp,
        endTime,
        rank,
        itemId,
        amount,
        ...rest
      } = this.data.prizeInitData;
      const { imageTips } = this.data;
      const { type: dialogType, maxRankLimit } = this.props;

      if (dialogType == "probability") {
        let probabilityRexp = /^\d+(\.\d{1,2})?$/;
        if (
          !probabilityRexp.test(probability) ||
          probability > 100 ||
          probability === ''
        ) {
          this.showItemTips(
            "probabilityTips",
            "error",
            "奖品概率必须大于0小于等于100且最多两位小数"
          );
        } else {
          this.showItemTips("probabilityTips", "success", "");
        }
      } else {
        this.showItemTips("probabilityTips", "success", "");
      }

      const {
        LUKCY_POCKET_TYPE,
        COUPON_TYPE,
        CREDITS_TYPE,
        OBJECT_TYPE,
      } = this.data;

      if (type === LUKCY_POCKET_TYPE && !ename) {
        my.showToast({
          type: "fail",
          content: "优惠券配置错误, 请重新配置",
        });
        return;
      }

      //使用链接
      if (type == EQUITY_TYPE) {
        if (!urlCheck(useUrl, passUrlList).status) {
          this.showItemTips(
            "useUrlTips",
            "error",
            urlCheck(useUrl, passUrlList).message
          );
        } else {
          this.showItemTips("useUrlTips", "success", "");
        }
      }
      //实物奖品的配置商品id
      // if (type == OBJECT_TYPE) {
      //   if (!goodsId) {
      //     this.showItemTips('goodsIdTips', 'error', '请选择商品链接');
      //   }
      //   else {
      //     this.showItemTips('goodsIdTips', 'success', '');
      //   }
      // }
      if (type == EQUITY_TYPE || type == OBJECT_TYPE) {
        if (!desc) {
          this.showItemTips("prizeDescTips", "error", "请填写奖品描述");
        } else {
          this.showItemTips("prizeDescTips", "success", "");
        }
        if (!name) {
          this.showItemTips("nameTips", "error", "请输入奖品名称");
        } else {
          this.showItemTips("nameTips", "success", "");
        }
        if (!image) {
          this.showItemTips("imageTips", "error", "请配置奖品图片");
        }
      }
      // 库存奖品的库存值判断
      let usePass = switchStock == 1 ? +stock > (useStock || 0) : true;
      let stockPass = switchStock == 1 ? validateRangeNumber(stock, [0, 99999]) : true;
      if (!stockPass || !usePass) {
        this.showItemTips(
          "prizeNumberTips",
          "error",
          "奖品库存为0-99999之间的整数且大于发放库存"
        );
      }
      else {
        this.showItemTips(
          "prizeNumberTips",
          "success",
          ""
        );
      }

      if (type == CREDITS_TYPE && !validateRangeNumber(credits, [0, 999])) {
        this.showItemTips(
          "creditsValueTips",
          "error",
          "请输入积分价值为0-999的整数"
        );
      } else {
        this.showItemTips("creditsValueTips", "success", "");
      }

      //排行榜奖品保存判断
      const rankArr = rank.split("-");
      let isRankPass =
        dialogType == "rank"
          ? rankArr.length == 2
            ? +rankArr[0] <= +rankArr[1]
            && /^[1-9]+[0-9]*$/.test(+rankArr[0])
            && /^[1-9]+[0-9]*$/.test(+rankArr[1])
            && isDot(rankArr[0])
            && isDot(rankArr[1])
            : false
          : true;
      if (dialogType === "rank") {
        if (!isRankPass) {
          this.showItemTips("rankValueTips", "error", "请输入正确的领奖名次");
        } else {
          this.showItemTips("rankValueTips", "success", "");
        }
        if (maxRankLimit && rankArr[rankArr.length - 1] > maxRankLimit) {
          my.showToast({
            type: "fail",
            content: `最多配置前${maxRankLimit}名奖品`,
          });
          return;
        }
      }
      const {
        probabilityTips,
        prizeNumberTips,
        creditsValueTips,
        useUrlTips,
        prizeDescTips,
        goodsIdTips,
        rankValueTips
      } = this.data;
      const isImagePass = image && imageTips.status !== "error";

      const isEquietyPass =
        type == EQUITY_TYPE &&
        !!name.trim() &&
        isImagePass &&
        !!ename &&
        probabilityTips.status !== "error" &&
        prizeNumberTips.status !== "error" &&
        useUrlTips.status !== "error" &&
        rankValueTips.status !== "error" &&
        prizeDescTips.status !== "error";
      const isObjectPass =
        type == OBJECT_TYPE &&
        !!name.trim() &&
        stockPass &&
        isImagePass &&
        probabilityTips.status !== "error" &&
        prizeNumberTips.status !== "error" &&
        rankValueTips.status !== "error" &&

        goodsIdTips.status !== "error" &&
        prizeDescTips.status !== "error";
      const isCreditsPass =
        type == CREDITS_TYPE &&
        name.trim() &&
        credits &&
        isImagePass &&
        probabilityTips.status !== "error" &&
        creditsValueTips.status !== "error";
      //限制库存时，限制库存一定要大于发放库存
      if (isEquietyPass || isObjectPass || isCreditsPass) {
        const { isEdit, prizeDialogData, onUpdate, onAdd, prizeDataType, conditionKeys } = this.props;


        let prizeData = {
          image,
          desc,
          useUrl,
          name,
          ename,
          type,
          probability,
          stock: +stock,
          credits: +credits,
          useStock: +useStock,
          rank,
          switchStock,
          isBackUp,
          prizeDataType:+prizeDataType,
          itemId,
          amount,
          ...rest,
        };
        // 自定义新增字段
        if (conditionKeys && conditionKeys.length) {
          const conditions = {}
          conditionKeys.forEach(item => {
            conditions[item.key] = +item.value
          });
          prizeData = {
            ...prizeData,
            ...conditions
          }
        }

        if (isEdit) {
          console.log(prizeData, "--prizeData--");
          onUpdate && onUpdate(prizeData, prizeDialogData.index);
        } else {
          onAdd && onAdd(prizeData);
        }

        this.onCloseDialog();
      } else {
        my.showToast({
          type: "fail",
          content: "请完整填写奖品信息",
        });
      }
    },
    showItemTips(type, status, content) {
      this.setData({
        [type]: {
          status,
          content,
        },
      });
    },
    onCloseDialog() {
      this.props.onClose && this.props.onClose();
    },
    onOpenDialog() {
      this.setData({
        goodsVisible: true,
        itemIds: this.data.prizeInitData.itemId ? this.data.prizeInitData.itemId + '' : null
      });
    },
    onCloseGoodsDialog() {
      this.setData({
        goodsVisible: false
      });
    },
    // 选择商品查看id
    onUpdateBabyChoose(ids) {
      if (!ids) {
        this.setData({
          itemIds: '',
          prizeInitData: {
            ...this.data.prizeInitData,
            itemId: '',
          },
        })
        return
      }
      const chooseId = ids.split(",").map((i) => +i);
      this.setData({
        itemIds: ids,
        prizeInitData: {
          ...this.data.prizeInitData,
          itemId: chooseId[0],
        },
      })
    },

  },
});
