import { getAuthUserInfo } from 'tbcc-sdk-ts/lib/core/tbFn'
import { useEffect } from 'react'

// 授权
export function useAuth(callback = noopFn) {
  const authUserInfo = async() => {
    const info = await getAuthUserInfo().catch(err => {
      console.log('未授权成功', err)
    })
    if (info) {
      callback(info)
    }
  }
  useEffect(() => {
    authUserInfo()
  }, [])

  return {}
}