import { View, Image, Text } from '@tarojs/components'
import React, { useState } from 'react'
import Modal from '@/components/_base/Modal/Modal'
import { useThrottle } from '@/hooks/useThrottle'
import styles from './PrizeModal.module.less'
import { BENEFIT_TYPE, PRIZE_TYPE } from '@/config/myPrize.config'
import { checkIsMember } from 'tbcc-sdk-ts/lib/utils'
import { commonToast, navigateToOutside } from  'tbcc-sdk-ts/lib/core/tb'
import { receiveEnamePrize, receiveObjectPrize, receiveMemberEname } from '@/utils/util'
import config from '@/config'

export default function PrizeModal(props) {
  const { prize = {}, onClose = () => {}, } = props
  const app = getApp()
  const { image = '', name = '', id = '', type = 1, benefitType	 = 1, ename = '' } = prize

  const [ memberModalVisible, setMemberModalVisible ] = useState(false)
  
  const onRecivePrize = useThrottle(async () => {
      const { activityId } = app
      const successMsg = '奖品发放成功，请前往我的奖品处进行使用'
      const errorMsg = '奖品发放失败，请前往我的奖品处进行处理'
      if(type === PRIZE_TYPE.CREDITS || (type === PRIZE_TYPE.ENAME && benefitType === BENEFIT_TYPE.MEMBER)) {
        const isVip = await checkIsMember()
        if(!isVip) {
            commonToast('加入会员才可领取哦')
            setMemberModalVisible(true)
            return;
        }
      }
      const receiveFn = {
        [PRIZE_TYPE.ENAME]: async () => {
          if(benefitType === BENEFIT_TYPE.MEMBER) {
            await receiveMemberEname({params: { sellerId: config.sellerId, ename, id }, successMsg, errorMsg })
          }else {
            await receiveEnamePrize({params: { activityId, id }, successMsg, errorMsg })
          }
        },
        [PRIZE_TYPE.OBJECT]: async () => {
          await receiveObjectPrize({params: { activityId, id }, successMsg, errorMsg })
        },
        [PRIZE_TYPE.CREDITS]: async () => {
          await receiveEnamePrize({params: { activityId, id }, successMsg, errorMsg })
        }
      }
      await receiveFn[type]()
      onClose()
  },2000)
  // 入会弹窗
  const onAuthSuccess = async() => {
    setMemberModalVisible(false)
    onRecivePrize()
  }
  const onAuthFail = () => {
    setMemberModalVisible(false)
  }
  const closeMemberModal = () => {
    setMemberModalVisible(false)
  }
  const onCloseModal = () => {
    onClose && onClose()
  }
  return (
    <>
      <Modal hideCloseButton={false} onClose={onCloseModal} top={'50%'}>
        <View className={styles['prize-container']}>
          <View className={styles['prize-name']}>{'获得'+name+'奖品'}</View>
          <View className={styles['prize-icon']}>
            <Image src={image} className={styles['prize-icon-img']} />
          </View>
          <Image src={'//yun.duiba.com.cn/taobaomini/pike_call/prize_btn.png'} onClick={() => onRecivePrize()} className={styles['prize-btn']} />
          <View className={styles['prize-desc']}>奖品可在我的奖品中查看</View>
        </View>
      </Modal>
      {
        memberModalVisible &&
          <member-modal
            onClose={() => closeMemberModal()}
            onAuthFail={onAuthFail}
            onAuthSuccess={onAuthSuccess}
          />
      }
    </>
  )
}