import React from 'react'
import { View, Text } from '@tarojs/components'
import styles from './Barrage.module.less'

class Barrage extends React.Component {
  constructor(props) {
    super(props)
    //  页面数据存储
    this.state = {
      barrageWay: [],
      barrageList: []
    }
    this.timer = null
  }

  componentDidMount() {
    this.createData()
    const self = this
    setTimeout(() => {
      self.addBarrageListObj()
    }, 200)
  }

  componentWillUnmount() {
    clearInterval(this.timer)
  }

  createData() {
    const { dataList, trackCount = 1 } = this.props
    const Tracks = Array.from(
      { length: trackCount },
      (v, k) => (k + 1) * 40 - 40
    )
    this.setState({
      barrageList: dataList.map((item, index) => ({
        width: item.length * 17 + 5,
        top: Tracks[index < Tracks.length ? index : index % trackCount],
        time: 5,
        context: item
      }))
    })
  }

  /* *
   * 因为从后台获取到的是全部的数据，所以要把数据分开，让每条数据有先后之分
   * 每隔一秒往barrageList 数组插入一条数据
   * */
  addBarrageListObj() {
    const self = this
    const { barrageList, barrageWay } = this.state
    let i = 0
    this.timer = setInterval(function () {
      barrageWay.push(barrageList[i])
      self.setState({
        barrageWay: barrageWay
      })
      i++
      if (i === barrageList.length - 1) {
        if (self.props.Infinite) {
          i = 0
        } else {
          clearInterval(self.timer)
        }
      }
    }, 1500)
  }

  render() {
    const { barrageWay } = this.state
    return (
      <View className={styles['barrage-fly']}>
        {barrageWay.map((item, i) => {
          if (!item?.context) return null
          return (
            <View
              key={i}
              className={styles['barrage-textFly']}
              style={`animation: ${styles.first} ${item.time}s linear  forwards; top: ${item.top}px`}
            >
              {/* 弹幕内容 */}
              <Text className={styles['barrage-text']}>{item.context}</Text>
            </View>
          )
        })}
      </View>
    )
  }
}

export default Barrage
