import { noopFn } from '@/utils/util'
import { View, Icon } from '@tarojs/components'
import classnames from 'classnames'
import React, { useEffect, useState } from 'react'
import Overlay from '../Overlay/Overlay'

import styles from './Popup.module.less'

export default function Popup(props) {
  const {
    onClose = noopFn,
    position = 'bottom',
    height = 'auto',
    width = '100%',
    backgroundColor = '#fff',
    closeOnClickOverlay = false,
    closebale = true,
    closeButtonStyle = { right: 6, top: -36 }
  } = props

  const [ isShowAnimate, setShowAnimate ] = useState(false)

  const onCloseModal = () => {
    setShowAnimate(true)
    setTimeout(() => {
      setShowAnimate(false)
      onClose()
    }, 350)
  }

  const onClickOverlay = () => {
    closeOnClickOverlay && onCloseModal()
  }

  const wrapClass = classnames(styles.wrap, {
    'animate-fade-out': isShowAnimate
  })

  const contentClass = classnames(styles.content, styles[position], {
    'animate-fly-in': true,
    'animate-fly-out': isShowAnimate
  })

  return (
    <View className={wrapClass}>
      <Overlay onTap={onClickOverlay} />

      <View className={contentClass} style={{ width, height, backgroundColor }}>
        {closebale && <View className={styles.close_button} onClick={onCloseModal} style={closeButtonStyle} />}
        {props.children}
      </View>

    </View>
  )
}
