/** @format */

export const exportHandlers = (controllers: any[]) => {
  const handlersMapper = controllers
    .map(controller => {
      const controllerInstance = new controller()
      const handlersKeys = Object.getOwnPropertyNames(Object.getPrototypeOf(controllerInstance)).filter(
        v => v !== 'constructor'
      )
      return handlersKeys.reduce((prev, current) => {
        return {
          ...prev,
          [current]: controllerInstance[current]
        }
      }, {})
    })
    .reduce((prev, current) => {
      return {
        ...current,
        ...prev
      }
    }, {})
  return handlersMapper
}
