import React, { useState, useEffect, useRef } from 'react'
import { Image, ScrollView, View } from '@tarojs/components'
import API from '@/api'
import DeliveryModal from '@/components/_tb_modal/DeliveryModal/DeliveryModal'
import ContainerFit from '@/components/_base/ContainerFit/ContainerFit'
import TitleImg from '@/components/_tb_comps/TitleImg/TitleImg'
import tbccTs from 'tbcc-sdk-ts'
import { useThrottle } from '@/hooks/useThrottle'
import { dateFormatter } from '@/utils/date'
import styles from './myPrize.module.less'
import { useDidHide, useDidShow, getApp } from '@tarojs/taro'
import useReceive from '@/hooks/useReceive'
import { PRIZE_CONFIG, DRAW_STATUS, PRIZE_TYPE } from '@/config/myPrize.config'

const { objectStatus: _objectStatus, enameStatus: _enameStatus, orderStatus, commonStatus, hasGoodPrize } = PRIZE_CONFIG
const objectStatus = { ..._objectStatus, ...commonStatus }
const enameStatus = { ..._enameStatus, ...commonStatus }

const { commonToast, navigateToOutside, setClipboard, openDetail } = tbccTs.tb

function Empty(blankTxt) {
  return <View className={styles['my-prize-item__empty']}>{blankTxt}</View>
}

function MyPrizeList() {
  const app = getApp()
  const { receivePrize } = useReceive({ successMsg: '领取成功', errorMsg: '' })
  const [ myPrizeList, setMyPrizeList ] = useState([])
  const [ expiredTime, setExpiredTime ] = useState('')
  const [ currentPrize, setCurrentPrize ] = useState({})
  const [ memberVisible, setMemberVisible ] = useState(false)
  const [ deliveryModalVisible, setDeliveryModalVisible ] = useState(false)
  const flashList = useRef(false)

  useEffect(() => {
    fetchMyPriceList()
  }, [])
  
  async function fetchMyPriceList() {
    const res = await API.getMyAwardsList()
    if (res.success && res?.data?.list?.length) {
      setMyPrizeList(res?.data?.list)
    }
    if (res?.data?.expiredTime) {
      setExpiredTime(dateFormatter(res?.data?.expiredTime, 'yyyy/MM/dd hh:mm:ss'))
    }
  }
  // 页面显示
  useDidShow(() => {
    if(flashList.current) {
      flashList.current = false
      fetchMyPriceList()
    }
  })
  // 复制编码
  const handleCopyId = async(text) => {
    await setClipboard(text)
    commonToast('复制成功')
  }
  // 领取奖品
  const handleClick = useThrottle(async (item) => {
      const { activityId } = app
      const { type, drawStatus, useUrl = '', itemId = '' } = item
      // 领取前验证
      if (drawStatus === DRAW_STATUS.SUCCESS) {
        if (type === PRIZE_TYPE.OBJECT && PRIZE_CONFIG.hasLogistic) {
          setCurrentPrize(item)
          setDeliveryModalVisible(true)
          return
        }
        if (type !== PRIZE_TYPE.OBJECT && useUrl) {
          navigateToOutside(useUrl)
          return
        }
      }
      if (!(drawStatus === DRAW_STATUS.RETRY || drawStatus === DRAW_STATUS.WAITAWARD)) {
        return
      }
      // 含有专属商品
      if(hasGoodPrize && itemId) {
        flashList.current = true
        await openDetail(String(itemId))
      }
      
      // 执行奖品领取
      receivePrize(item,{
        vipCallback:()=>{
          console.log('enter the vip callback function');
          setMemberVisible(true)
        },
        updateCallback:()=>{
          console.log('enter the update list callback function');
          fetchMyPriceList()
        }
      });
  },1500)
  // 入会插件
  const onClose = () => {
    setMemberVisible(false)
  }
  const onAuthSuccess = () => {
    setMemberVisible(false)
  }
  const onAuthFail = () => {
    setMemberVisible(false)
  }

  // 获取btn img
  const getItmImg = (itm) => {
    const { type, itemId, drawStatus, useUrl = '' } = itm
    if(itemId && hasGoodPrize) return orderStatus[drawStatus]
    if(type === PRIZE_TYPE.OBJECT) return objectStatus[drawStatus]
    if(type === PRIZE_TYPE.ENAME && drawStatus === DRAW_STATUS.SUCCESS && !useUrl) return PRIZE_CONFIG.receiveBtn
    if(type === PRIZE_TYPE.ENAME) return enameStatus[drawStatus]
  }

  return (
    <>
    <ContainerFit bg={PRIZE_CONFIG.bg}>
        <View className={styles['my-prize-label']}>
          <TitleImg config={PRIZE_CONFIG.head}></TitleImg>
        </View>
        <View className={styles['my-prize-content']} style={{ top: PRIZE_CONFIG.contentTop }}>
          <ScrollView scrollY className={styles['my-prize-content__scroll']}>
            {myPrizeList.length > 0 &&
              <View className={styles['my-prize-list']}>
                {myPrizeList.map((item, i) => {
                  return (
                    <View className={styles['my-prize-item']} key={'prize_'+i}>
                      <Image className={styles['my-prize-item__avatar']} src={item.image} />

                      <View className={styles['my-prize-item__content']}>
                        <View className={styles['my-prize-item__name']}>{item.name}</View>
                        {
                          PRIZE_CONFIG.isShowPirzeId &&
                            <View className={styles['my-prize-item__subtitle']}>
                              <View className={styles['my-prize-item__code']}>奖品编码：{item.id || item._id}</View>
                              {/* <!-- 复制按钮 --> */}
                              <Image className={styles['my-prize-item__copy']} onTap={() => handleCopyId(item.id || item._id)} src={PRIZE_CONFIG.copyIcon} />
                            </View>
                        }
                        {item.drawStatus === DRAW_STATUS.FAIL && <View className={styles['my-prize-item__tip']}>{item.remark}</View>}
                        {(item.drawStatus === DRAW_STATUS.RETRY || item.drawStatus === DRAW_STATUS.WAITAWARD) && <View className={styles['my-prize-item__tip']}>请于{expiredTime}前领取</View>}
                        {item.drawStatus === DRAW_STATUS.EXPIRED && <View className={styles['my-prize-item__tip']}>奖品已过期失效</View>}

                      </View>
                      <View className={styles['prize-item__status']} style={PRIZE_CONFIG.btnStyle}>
                        <Image onTap={() => handleClick(item)} src={getItmImg(item)} mode='widthFix' />
                      </View>
                    </View>
                  )
                })}
              </View>}
            {
              myPrizeList.length === 0 && Empty(PRIZE_CONFIG.blankTxt)
            }
          </ScrollView>
        </View>
    </ContainerFit>
      {deliveryModalVisible && <DeliveryModal prizeItem={currentPrize} task={PRIZE_CONFIG.logisticsImage} onClose={() => setDeliveryModalVisible(false)} />}
      {<member-modal expend={memberVisible} onClose={onClose} onAuthFail={onAuthFail} onAuthSuccess={onAuthSuccess} />}
    </>
  )
}
export default MyPrizeList