##### ScrollXView滑动配置项

+ 入参

|    配置项    |   类型   |    描述     |  默认值  |  备注  |
| :--------   | :-----:  | :--------: | :-----:  | :---:|
| prizeList    |   Array   |    滑动数据   |  [...]  | / |
| containerWidth    |   Number   |    单个奖品容器的宽度   | 300 | / |
| containerHeight    |   Number   |    单个奖品容器的高度   |  300  | / |
| imgWidth    |   Number   |    奖品图片宽度   |  200  | / |
| imgHeight    |   Number   |    奖品图片高度   |  200  | / |
| isShowPrizeName    |   Boolean   |    是否展示奖品名称   |  true  | true:展示  false:不展示 |
| prizeInCenterNum    |   Number   |    奖品少于n个时居中展示   |  n=2  | 多于n个,可滑动查看 |
| marginRight    |   Number   |    奖品容器之间间距   |  26  | px |
| backgroundColor    |   String   |    奖品容器背景颜色   |  #E7E7EF  | / |
| backgroundImage    |   String   |    奖品容器背景图   |  ''  | 默认为空 |

+ prizeList数组格式
```json
    [
        {
            "image":"",
            "name":"xxx",
            // ...
        },
        // ...
    ]
```

+ 使用
```jsx
    import ScrollXView from '@/components/_tb_comps/ScrollXView/ScrollXView'
    // 组件不一定在该目录下,仅做举例引入

    const SCROLLXVIEW_CONFIG = {  //不传走默认配置
        prizeList: [], 
        containerWidth : 300, 
        containerHeight : 300,
        imgWidth:200,
        imgHeight:200,
        isShowPrizeName:true,
        prizeInCenterNum:2,
        marginRight:26,
        backgroundColor:'#E7E7EF',
        backgroundImage:''
    }

    export const Index = () => {
        return(
            <View className="scroll">
                <ScrollXView {...SCROLLXVIEW_CONFIG} prizeList={prizeList} />
            </View>
        )
    }

```